/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Alert;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.beans.Beans;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class AlertRenderer
extends AbstractRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderOuterDiv(FacesContext context, Alert alert, ResponseWriter writer) throws IOException {
        Theme theme = ThemeUtilities.getTheme(context);
        String defaultStyleClass = theme.getStyleClass("ALERT_DIV");
        this.renderOuterDiv(context, alert, defaultStyleClass, writer);
    }

    protected void renderOuterDiv(FacesContext context, Alert alert, String defaultStyleClass, ResponseWriter writer) throws IOException {
        String styleClass;
        String style = alert.getStyle();
        String id = alert.getClientId(context);
        writer.startElement("div", alert);
        if (id != null) {
            writer.writeAttribute("id", id, null);
        }
        if (style != null) {
            writer.writeAttribute("style", style, null);
        }
        styleClass = (styleClass = alert.getStyleClass()) == null || styleClass.length() == 0 ? defaultStyleClass : null;
        RenderingUtilities.renderStyleClass(context, writer, alert, styleClass);
    }

    protected void renderOpeningTable(Alert alert, ResponseWriter writer) throws IOException {
        writer.startElement("table", alert);
        writer.writeAttribute("border", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("title", "", null);
        writer.writeText("\n", null);
    }

    protected void renderTopRow(Alert alert, String spacerPath, String[] styles, ResponseWriter writer) throws IOException {
        writer.startElement("tr", alert);
        writer.writeText("\n", null);
        this.renderSpacerCell(alert, styles[0], spacerPath, writer);
        this.renderSpacerCell(alert, styles[1], spacerPath, writer);
        this.renderSpacerCell(alert, styles[2], spacerPath, writer);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    protected void renderMiddleRow(Alert alert, Theme theme, String spacerPath, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("tr", alert);
        writer.writeAttribute("class", styles[3], null);
        writer.writeText("\n", null);
        writer.startElement("td", alert);
        writer.writeAttribute("class", styles[4], null);
        writer.writeText("\n", null);
        this.renderSpacerImage(alert, spacerPath, writer);
        writer.endElement("td");
        writer.writeText("\n", null);
        this.renderMiddleCell(context, alert, theme, writer, styles);
        writer.startElement("td", alert);
        writer.writeAttribute("class", styles[9], null);
        writer.writeText("\n", null);
        this.renderSpacerImage(alert, spacerPath, writer);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    protected void renderBottomRow(Alert alert, Theme theme, String spacerPath, String[] styles, ResponseWriter writer) throws IOException {
        writer.startElement("tr", alert);
        writer.writeText("\n", null);
        this.renderSpacerCell(alert, styles[10], spacerPath, writer);
        this.renderSpacerCell(alert, styles[11], spacerPath, writer);
        this.renderSpacerCell(alert, styles[12], spacerPath, writer);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    protected void renderSpacerCell(Alert alert, String styleClass, String spacerPath, ResponseWriter writer) throws IOException {
        writer.startElement("td", alert);
        writer.writeText("\n", null);
        writer.startElement("div", alert);
        writer.writeAttribute("class", styleClass, null);
        this.renderSpacerImage(alert, spacerPath, writer);
        writer.endElement("div");
        writer.writeText("\n", null);
        writer.endElement("td");
        writer.writeText("\n", null);
    }

    protected void renderMiddleCell(FacesContext context, Alert alert, Theme theme, ResponseWriter writer, String[] styles) throws IOException {
        writer.startElement("td", alert);
        writer.writeText("\n", null);
        writer.startElement("div", alert);
        writer.writeAttribute("class", styles[5], null);
        writer.startElement("div", alert);
        writer.writeAttribute("class", styles[6], null);
        this.renderAlertIcon(context, alert, theme, writer);
        this.renderAlertSummaryText(alert, styles, writer, context);
        writer.endElement("div");
        writer.writeText("\n", null);
        this.renderAlertDetailArea(context, alert, theme, styles, writer);
        writer.endElement("div");
        writer.writeText("\n", null);
        writer.endElement("td");
        writer.writeText("\n", null);
    }

    protected void renderAlertIcon(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent alertIcon = alert.getAlertIcon();
        RenderingUtilities.renderComponent(alertIcon, context);
    }

    protected void renderAlertSummaryText(Alert alert, String[] styles, ResponseWriter writer) throws IOException {
        String summary = alert.getSummary();
        writer.startElement("span", alert);
        writer.writeAttribute("class", styles[7], null);
        writer.writeText("\n", null);
        writer.writeText(summary, null);
        writer.endElement("span");
        writer.writeText("\n", null);
    }

    protected void renderAlertSummaryText(Alert alert, String[] styles, ResponseWriter writer, FacesContext context) throws IOException {
        String summary = alert.getSummary();
        if (summary != null) {
            writer.startElement("span", alert);
            writer.writeAttribute("class", styles[7], null);
            writer.writeText("\n", null);
            this.renderFormattedMessage(writer, alert, context, summary);
            writer.endElement("span");
            writer.writeText("\n", null);
        }
    }

    protected void renderAlertDetailArea(FacesContext context, Alert alert, Theme theme, String[] styles, ResponseWriter writer) throws IOException {
        String detail = alert.getDetail();
        List<UIComponent> children = alert.getChildren();
        if ((detail == null || detail.trim().length() == 0) && children.size() <= 0) {
            return;
        }
        writer.startElement("div", alert);
        writer.writeAttribute("class", styles[8], null);
        if (detail != null) {
            writer.startElement("span", alert);
            writer.writeAttribute("class", styles[7], null);
            writer.writeText("\n", null);
            this.renderFormattedMessage(writer, alert, context, detail);
            writer.endElement("span");
            writer.writeText("\n", null);
        }
        super.encodeChildren(context, alert);
        this.renderAlertLink(context, alert, theme, writer);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderAlertLink(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent link = alert.getAlertLink();
        if (link != null) {
            RenderingUtilities.renderComponent(link, context);
        }
    }

    protected void renderClosingTags(ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Alert alert = (Alert)component;
        String summary = alert.getSummary();
        if (summary == null || summary.trim().length() == 0) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String spacerPath = theme.getImagePath("DOT");
        String[] styles = this.getStyles(theme);
        if (!RenderingUtilities.isPortlet(context) && !Beans.isDesignTime()) {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String viewId = context.getViewRoot().getViewId();
            String urlString = context.getApplication().getViewHandler().getActionURL(context, viewId);
            Cookie cookie = new Cookie(viewId, "");
            cookie.setPath(urlString);
            response.addCookie(cookie);
        }
        String defaultStyleClass = theme.getStyleClass("ALERT_DIV");
        this.renderOuterDiv(context, alert, defaultStyleClass, writer);
        this.renderOpeningTable(alert, writer);
        this.renderTopRow(alert, spacerPath, styles, writer);
        this.renderMiddleRow(alert, theme, spacerPath, styles, context, writer);
        this.renderBottomRow(alert, theme, spacerPath, styles, writer);
        this.renderClosingTags(writer);
    }

    private void renderFormattedMessage(ResponseWriter writer, UIComponent component, FacesContext context, String msg) throws IOException {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            parameterList.add(((UIParameter)kid).getValue());
        }
        String message = null;
        message = parameterList.size() > 0 ? MessageFormat.format(msg, parameterList.toArray(new Object[parameterList.size()])) : msg;
        if (message != null) {
            writer.write(message);
        }
    }

    private void renderSpacerImage(Alert alert, String spacerPath, ResponseWriter writer) throws IOException {
        writer.startElement("img", alert);
        writer.writeAttribute("src", spacerPath, null);
        writer.writeAttribute("alt", "", null);
        writer.endElement("img");
    }

    private String[] getStyles(Theme theme) {
        String[] styles = new String[]{theme.getStyleClass("ALERT_TOP_LEFT_CORNER"), theme.getStyleClass("ALERT_TOP_MIDDLE"), theme.getStyleClass("ALERT_TOP_RIGHT_CORNER"), theme.getStyleClass("ALERT_MIDDLE_ROW"), theme.getStyleClass("ALERT_LEFT_MIDDLE"), theme.getStyleClass("ALERT_MIDDLE"), theme.getStyleClass("ALERT_HEADER"), theme.getStyleClass("ALERT_TEXT"), theme.getStyleClass("ALERT_DETAILS"), theme.getStyleClass("ALERT_RIGHT_MIDDLE"), theme.getStyleClass("ALERT_BOTTOM_LEFT_CORNER"), theme.getStyleClass("ALERT_BOTTOM_MIDDLE"), theme.getStyleClass("ALERT_BOTTOM_RIGHT_CORNER")};
        return styles;
    }
}

