/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class CalendarMonthRenderer
extends AbstractRenderer {
    private static final boolean DEBUG = false;
    private static final String SKIP_SECTION = "skipSection";
    private static final String CURR_YEAR_ATTR = "currYear";
    private static final String CURR_MONTH_ATTR = "currMonth";
    private static final String CLOSE_IMAGE = "_closeImage";

    private void renderDateTableStart(CalendarMonth calendarMonth, String[] styles, ResponseWriter writer) throws IOException {
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[4], null);
        writer.write("\n");
        writer.startElement("table", calendarMonth);
        writer.writeAttribute("width", "100%", null);
        writer.writeAttribute("cellspacing", "1", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("border", "0", null);
        writer.write("\n");
        writer.startElement("tbody", calendarMonth);
        writer.writeAttribute("class", styles[5], null);
        writer.write("\n");
    }

    private void renderDayHeaderRow(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("tr", calendarMonth);
        writer.write("\n");
        int firstDay = calendarMonth.getCalendar().getFirstDayOfWeek();
        String[] daysOfWeek = new String[8];
        daysOfWeek[2] = styles[8];
        daysOfWeek[3] = styles[9];
        daysOfWeek[4] = styles[10];
        daysOfWeek[5] = styles[11];
        daysOfWeek[6] = styles[12];
        daysOfWeek[7] = styles[13];
        daysOfWeek[1] = styles[14];
        String styleClass = styles[15];
        for (int i = 0; i < 7; ++i) {
            this.renderWeekdayHeader(calendarMonth, writer, styleClass, daysOfWeek[firstDay]);
            writer.write("\n");
            if (++firstDay != 8) continue;
            firstDay = 1;
        }
        writer.endElement("tr");
        writer.write("\n");
    }

    private void renderWeekdayHeader(CalendarMonth calendarMonth, ResponseWriter writer, String styleClass, String header) throws IOException {
        writer.startElement("th", calendarMonth);
        writer.writeAttribute("align", "center", null);
        writer.writeAttribute("scope", "col", null);
        writer.write("\n");
        writer.startElement("span", calendarMonth);
        writer.writeAttribute("class", styleClass, null);
        writer.write("\n");
        writer.writeText(header, null);
        writer.write("\n");
        writer.endElement("span");
        writer.write("\n");
        writer.endElement("th");
    }

    private void renderDays(CalendarMonth calendarMonth, String id, String[] styles, DateFormat dateFormat, ResponseWriter writer) throws IOException {
        int i;
        String rowId;
        Calendar monthToShow = calendarMonth.getCalendar();
        monthToShow.set(1, calendarMonth.getCurrentYear());
        monthToShow.set(2, calendarMonth.getCurrentMonth() - 1);
        monthToShow.set(5, 1);
        int weekStartDay = monthToShow.getFirstDayOfWeek();
        Calendar startDate = (Calendar)monthToShow.clone();
        while (startDate.get(7) != weekStartDay) {
            startDate.add(5, -1);
            startDate.getTime();
        }
        Calendar endDate = (Calendar)monthToShow.clone();
        endDate.add(2, 1);
        endDate.getTime();
        if (endDate.get(7) == weekStartDay) {
            endDate.add(5, -1);
            endDate.getTime();
        } else {
            while (endDate.get(7) != weekStartDay) {
                endDate.add(5, 1);
                endDate.getTime();
            }
            endDate.add(5, -1);
            endDate.getTime();
        }
        String rowIdPrefix = id.concat(":row");
        String dateLinkPrefix = id.concat(":dateLink");
        int displayedMonth = monthToShow.get(2);
        Calendar todaysDate = calendarMonth.getCalendar();
        int dateLinkId = 0;
        int rowNum = 0;
        while (startDate.before(endDate)) {
            writer.startElement("tr", calendarMonth);
            rowId = rowIdPrefix + rowNum++;
            writer.writeAttribute("id", rowId, null);
            writer.write("\n");
            for (i = 0; i < 7; ++i) {
                boolean selected = calendarMonth.isDateSelected(startDate, endDate);
                boolean dayInMonth = startDate.get(2) == displayedMonth;
                String style = styles[17];
                if (selected) {
                    style = dayInMonth ? styles[18] : styles[19];
                } else if (dayInMonth) {
                    style = calendarMonth.compareDate(startDate, todaysDate) ? styles[20] : styles[16];
                }
                this.renderDateLink(startDate, style, dateLinkPrefix.concat(String.valueOf(dateLinkId)), calendarMonth, dateFormat, writer);
                ++dateLinkId;
                startDate.add(6, 1);
                startDate.getTime();
            }
            writer.endElement("tr");
            writer.write("\n");
        }
        if (rowNum < 6) {
            writer.startElement("tr", calendarMonth);
            rowId = rowIdPrefix + rowNum++;
            writer.writeAttribute("id", rowId, null);
            writer.writeAttribute("style", "display:none;", null);
            writer.write("\n");
            for (i = 0; i < 7; ++i) {
                this.renderDateLink(startDate, styles[17], dateLinkPrefix.concat(String.valueOf(dateLinkId)), calendarMonth, dateFormat, writer);
                ++dateLinkId;
                startDate.add(6, 1);
                startDate.getTime();
            }
            writer.endElement("tr");
            writer.write("\n");
        }
    }

    private void renderDateLink(Calendar startDate, String style, String id, CalendarMonth calendarMonth, DateFormat dateFormat, ResponseWriter writer) throws IOException {
        writer.startElement("td", calendarMonth);
        writer.writeAttribute("align", "center", null);
        writer.writeText("\n", null);
        int day = startDate.get(5);
        writer.startElement("a", calendarMonth);
        writer.writeAttribute("class", style, null);
        writer.writeAttribute("id", id, null);
        String dateString = dateFormat.format(startDate.getTime());
        writer.writeAttribute("title", dateString, null);
        StringBuffer buffer = new StringBuffer(128);
        if (calendarMonth.isPopup()) {
            buffer.append(calendarMonth.getJavaScriptObjectName());
            buffer.append(".dayClicked(this); return false;");
        } else {
            buffer.append(calendarMonth.getJavaScriptObjectName());
            buffer.append(".setDateValue('");
            buffer.append(dateString);
            buffer.append("', this); return false;");
        }
        writer.writeAttribute("onclick", buffer.toString(), null);
        writer.writeAttribute("href", "#", null);
        writer.write(String.valueOf(day));
        writer.endElement("a");
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
    }

    private void renderDateTableEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
        writer.write("\n");
        writer.endElement("table");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
    }

    private void renderCalendarHeader(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer, Theme theme) throws IOException {
        this.renderHeaderTable(calendarMonth, writer, styles, theme);
        this.renderTodayDate(calendarMonth, writer, styles, theme, context);
    }

    private void renderHeaderTable(CalendarMonth calendarMonth, ResponseWriter writer, String[] styles, Theme theme) throws IOException {
        writer.startElement("table", calendarMonth);
        writer.writeAttribute("border", "0", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        writer.writeAttribute("width", "100%", null);
        writer.write("\n");
        writer.startElement("tr", calendarMonth);
        writer.writeText("\n", null);
        this.renderHeaderCornerCell(calendarMonth, writer, theme.getImagePath("SCHEDULER_TOP_LEFT"));
        String path = theme.getImagePath("DOT");
        writer.startElement("td", calendarMonth);
        writer.writeAttribute("class", styles[23], null);
        writer.writeAttribute("width", "100%", null);
        writer.startElement("img", calendarMonth);
        writer.writeAttribute("src", path, null);
        writer.writeAttribute("height", String.valueOf(1), null);
        writer.writeAttribute("width", String.valueOf(10), null);
        writer.writeAttribute("alt", "", null);
        writer.endElement("img");
        writer.endElement("td");
        writer.writeText("\n", null);
        this.renderHeaderCornerCell(calendarMonth, writer, theme.getImagePath("SCHEDULER_TOP_RIGHT"));
        writer.endElement("tr");
        writer.writeText("\n", null);
        writer.endElement("table");
        writer.writeText("\n", null);
    }

    private void renderHeaderCornerCell(CalendarMonth calendarMonth, ResponseWriter writer, String src) throws IOException {
        writer.startElement("td", calendarMonth);
        writer.writeAttribute("width", "6", null);
        writer.writeText("\n", null);
        writer.startElement("img", calendarMonth);
        writer.writeAttribute("src", src, null);
        writer.writeAttribute("alt", "", null);
        writer.endElement("img");
        writer.endElement("td");
        writer.writeText("\n", null);
    }

    private void renderTodayDate(CalendarMonth calendarMonth, ResponseWriter writer, String[] styles, Theme theme, FacesContext context) throws IOException {
        this.renderTodayDateBegin(calendarMonth, writer, styles);
        this.renderTodayDateText(calendarMonth, writer, context, styles, theme);
        if (calendarMonth.isPopup()) {
            this.renderCloseButton(calendarMonth, styles, context, writer, theme);
        }
        this.renderTodayDateEnd(writer);
    }

    private void renderTodayDateBegin(CalendarMonth calendarMonth, ResponseWriter writer, String[] styles) throws IOException {
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[22], null);
        writer.write("\n");
    }

    private void renderTodayDateText(CalendarMonth calendarMonth, ResponseWriter writer, FacesContext context, String[] styles, Theme theme) throws IOException {
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[24], null);
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(2, context.getViewRoot().getLocale());
        dateFormat.setTimeZone(calendarMonth.getTimeZone());
        Date today = calendarMonth.getCalendar().getTime();
        Object[] detailArg = new String[]{dateFormat.format(today)};
        String detailMsg = theme.getMessage("CalendarMonth.todayIs", detailArg);
        writer.writeText(detailMsg, null);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    private void renderTodayDateEnd(ResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    private void renderCalendarControls(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        String id = calendarMonth.getClientId(context);
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[3], null);
        writer.writeText("\n", null);
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[26], null);
        String pattern = calendarMonth.getDateFormatPattern();
        if (pattern.indexOf("yyyy") < pattern.indexOf("MM")) {
            this.renderYearControl(calendarMonth, styles, context, writer);
            writer.endElement("div");
            writer.writeText("\n", null);
            writer.startElement("div", calendarMonth);
            writer.writeAttribute("class", styles[27], null);
            this.renderMonthControl(calendarMonth, styles, context, writer);
        } else {
            this.renderMonthControl(calendarMonth, styles, context, writer);
            writer.endElement("div");
            writer.writeText("\n", null);
            writer.startElement("div", calendarMonth);
            writer.writeAttribute("class", styles[27], null);
            this.renderYearControl(calendarMonth, styles, context, writer);
        }
        writer.endElement("div");
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    private void renderYearControl(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        DropDown yearDropDown = calendarMonth.getYearMenu();
        yearDropDown.setToolTip(styles[6]);
        RenderingUtilities.renderComponent(yearDropDown, context);
        writer.write("\n");
    }

    private void renderMonthControl(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        IconHyperlink decreaseLink = calendarMonth.getPreviousMonthLink();
        RenderingUtilities.renderComponent(decreaseLink, context);
        writer.write("\n");
        DropDown monthDropDown = calendarMonth.getMonthMenu();
        monthDropDown.setToolTip(styles[7]);
        RenderingUtilities.renderComponent(monthDropDown, context);
        writer.write("\n");
        IconHyperlink increaseLink = calendarMonth.getNextMonthLink();
        RenderingUtilities.renderComponent(increaseLink, context);
        writer.write("\n");
    }

    private void renderCloseButton(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer, Theme theme) throws IOException {
        RenderingUtilities.renderAnchor(SKIP_SECTION, calendarMonth, context);
        StringBuffer strBuffer = new StringBuffer(128);
        strBuffer.append(calendarMonth.getJavaScriptObjectName());
        strBuffer.append(".setInitialFocus(); ");
        strBuffer.append(calendarMonth.getJavaScriptObjectName());
        strBuffer.append(".toggle(); return false;");
        writer.startElement("a", calendarMonth);
        writer.writeAttribute("onclick", strBuffer.toString(), null);
        writer.writeAttribute("class", styles[25], null);
        writer.writeAttribute("href", "#", null);
        Icon icon = ThemeUtilities.getIcon(theme, "CALENDAR_CLOSE_BUTTON");
        icon.setParent(calendarMonth);
        icon.setId(CLOSE_IMAGE);
        RenderingUtilities.renderComponent(icon, context);
        writer.endElement("a");
        writer.write("\n");
    }

    protected void renderSpacerImage(FacesContext context, CalendarMonth calendarMonth, Theme theme, int height, int width) throws IOException {
        Icon dot = ThemeUtilities.getIcon(theme, "DOT");
        dot.setWidth(width);
        dot.setHeight(height);
        dot.setId("icon");
        dot.setAlt("");
        RenderingUtilities.renderComponent(dot, context);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof CalendarMonth)) {
            Object[] params = new Object[]{component.toString(), this.getClass().getName(), CalendarMonth.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        CalendarMonth calendarMonth = (CalendarMonth)component;
        SimpleDateFormat dateFormat = (SimpleDateFormat)calendarMonth.getDateFormat();
        this.initializeChildren(calendarMonth, dateFormat, context);
        ResponseWriter writer = context.getResponseWriter();
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = this.getStyles(calendarMonth, context, theme);
        String id = calendarMonth.getClientId(context);
        if (calendarMonth.isPopup()) {
            this.renderPopupStart(calendarMonth, id, styles, context, writer);
        } else {
            writer.startElement("div", calendarMonth);
            writer.writeAttribute("id", id, null);
            writer.writeText("\n", null);
        }
        this.renderCalendarHeader(calendarMonth, styles, context, writer, theme);
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[4], null);
        writer.writeText("\n", null);
        this.renderCalendarControls(calendarMonth, styles, context, writer);
        this.renderDateTable(calendarMonth, styles, id, dateFormat, context, writer);
        writer.endElement("div");
        writer.write("\n");
        if (calendarMonth.isPopup()) {
            this.renderPopupEnd(writer);
        } else {
            writer.endElement("div");
            writer.write("\n");
        }
    }

    private void renderPopupStart(CalendarMonth calendarMonth, String id, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("id", id, null);
        writer.writeAttribute("class", styles[0], null);
        writer.writeText("\n", null);
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[1], null);
        writer.writeText("\n", null);
        writer.startElement("div", calendarMonth);
        writer.writeAttribute("class", styles[2], null);
        writer.writeText("\n", null);
    }

    private void renderPopupEnd(ResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
    }

    private void renderDateTable(CalendarMonth calendarMonth, String[] styles, String id, DateFormat dateFormat, FacesContext context, ResponseWriter writer) throws IOException {
        RenderingUtilities.renderSkipLink(SKIP_SECTION, styles[21], null, null, null, calendarMonth, context);
        this.renderDateTableStart(calendarMonth, styles, writer);
        this.renderDayHeaderRow(calendarMonth, styles, context, writer);
        this.renderDays(calendarMonth, id, styles, dateFormat, writer);
        this.renderDateTableEnd(writer);
        if (!calendarMonth.isPopup()) {
            RenderingUtilities.renderAnchor(SKIP_SECTION, calendarMonth, context);
        }
    }

    private void initializeChildren(CalendarMonth cm, SimpleDateFormat dateFormat, FacesContext context) {
        boolean updateCalendarControls = false;
        Calendar calendar = cm.getCalendar();
        Date displayDate = calendar.getTime();
        Integer year = cm.getCurrentYear();
        Integer month = cm.getCurrentMonth();
        if (year != null && month != null) {
            calendar.set(1, year);
            calendar.set(2, month - 1);
        } else {
            updateCalendarControls = true;
        }
        Date minDate = null;
        Date maxDate = null;
        UIComponent parent = cm.getParent();
        if (parent instanceof DateManager) {
            minDate = ((DateManager)((Object)parent)).getFirstAvailableDate();
            maxDate = ((DateManager)((Object)parent)).getLastAvailableDate();
        }
        if (displayDate.before(minDate)) {
            displayDate = minDate;
            updateCalendarControls = true;
        }
        if (maxDate.before(displayDate)) {
            displayDate = maxDate;
            updateCalendarControls = true;
        }
        DropDown yearMenu = cm.getYearMenu();
        DropDown monthMenu = cm.getMonthMenu();
        if (updateCalendarControls) {
            calendar.setTime(displayDate);
            String yearValue = String.valueOf(calendar.get(1));
            yearMenu.setSubmittedValue(new String[]{yearValue});
            String monthValue = String.valueOf(calendar.get(2) + 1);
            monthMenu.setSubmittedValue(new String[]{monthValue});
        }
        calendar.setTime(minDate);
        int firstYear = calendar.get(1);
        calendar.setTime(maxDate);
        int lastYear = calendar.get(1);
        int numYears = lastYear - firstYear + 1;
        Integer yearInteger = null;
        Option[] yearOptions = new Option[numYears];
        for (int i = 0; i < numYears; ++i) {
            yearInteger = new Integer(firstYear + i);
            yearOptions[i] = new Option(yearInteger, yearInteger.toString());
        }
        yearMenu.setItems(yearOptions);
        String[] monthNames = dateFormat.getDateFormatSymbols().getMonths();
        Option[] months = new Option[12];
        calendar.set(2, 0);
        for (int i = 0; i < 12; ++i) {
            int monthInt = calendar.get(2);
            months[i] = new Option(new Integer(monthInt + 1), monthNames[i]);
            calendar.add(2, 1);
        }
        monthMenu.setItems(months);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return this.getClass().getName();
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String[] getStyles(CalendarMonth calendarMonth, FacesContext context, Theme theme) {
        String[] styles = new String[]{theme.getStyleClass("CALENDAR_DIV_SHOW"), theme.getStyleClass("CALENDAR_DIV_SHOW2"), theme.getStyleClass("CALENDAR_DIV"), theme.getStyleClass("DATE_TIME_SELECT_DIV"), theme.getStyleClass("DATE_TIME_CALENDAR_DIV"), theme.getStyleClass("DATE_TIME_CALENDAR_TABLE"), theme.getMessage("CalendarMonth.selectYear"), theme.getMessage("CalendarMonth.selectMonth"), theme.getMessage("CalendarMonth.weekdayMon"), theme.getMessage("CalendarMonth.weekdayTue"), theme.getMessage("CalendarMonth.weekdayWed"), theme.getMessage("CalendarMonth.weekdayThu"), theme.getMessage("CalendarMonth.weekdayFri"), theme.getMessage("CalendarMonth.weekdaySat"), theme.getMessage("CalendarMonth.weekdaySun"), theme.getStyleClass("DATE_TIME_DAY_HEADER"), theme.getStyleClass("DATE_TIME_LINK"), theme.getStyleClass("DATE_TIME_OTHER_LINK"), theme.getStyleClass("DATE_TIME_BOLD_LINK"), theme.getStyleClass("DATE_TIME_OTHER_BOLD_LINK"), theme.getStyleClass("DATE_TIME_TODAY_LINK"), theme.getStyleClass("SKIP_MEDIUM_GREY1"), theme.getStyleClass("DATE_TIME_SELECT_CONTENT"), theme.getStyleClass("DATE_TIME_SELECT_TOP_MIDDLE"), theme.getStyleClass("DATE_TIME_SELECT_DATE"), theme.getStyleClass("CALENDAR_CLOSE_BUTTON"), theme.getStyleClass("DATE_TIME_CALENDAR_LEFT"), theme.getStyleClass("DATE_TIME_CALENDAR_RIGHT")};
        return styles;
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
    }
}

