/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Calendar;
import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.renderkit.html.FieldRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarRenderer
extends FieldRenderer {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Calendar)) {
            Object[] params = new Object[]{component.toString(), this.getClass().getName(), Calendar.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        Calendar calendar = (Calendar)component;
        boolean readOnly = calendar.isReadOnly();
        ResponseWriter writer = context.getResponseWriter();
        String[] styles = this.getStyles(calendar, context);
        String clientId = calendar.getClientId(context);
        this.renderTableStart(calendar, styles[18], styles[2], context, writer);
        UIComponent label = calendar.getLabelComponent(context, null);
        if (label != null) {
            this.renderCellStart(calendar, styles[6], writer);
            RenderingUtilities.renderComponent(label, context);
            this.renderCellEnd(writer);
        }
        if (readOnly) {
            this.renderCellStart(calendar, styles[6], writer);
            UIComponent text = calendar.getReadOnlyComponent(context);
            RenderingUtilities.renderComponent(text, context);
            if (calendar.getValue() != null) {
                this.renderPattern(calendar, styles[7], styles[2], context, writer);
            }
        } else {
            this.renderCellStart(calendar, styles[4], writer);
            this.renderInput(calendar, "text", clientId.concat("_field"), false, styles, context, writer);
            writer.write("\n");
            this.renderPattern(calendar, styles[7], styles[2], context, writer);
        }
        this.renderCellEnd(writer);
        if (!readOnly) {
            writer.startElement("td", calendar);
            writer.writeAttribute("valign", "top", null);
            writer.writeText("\n", null);
            writer.startElement("div", calendar);
            writer.writeAttribute("style", "position: relative;", null);
            writer.writeText("\n", null);
            writer.startElement("span", calendar);
            writer.writeAttribute("class", styles[5], null);
            UIComponent comp = calendar.getFacet("datePickerLink");
            if (comp instanceof ImageHyperlink) {
                RenderingUtilities.renderComponent(comp, context);
            } else {
                ImageHyperlink datePickerLink = new ImageHyperlink();
                datePickerLink.setParent(calendar);
                StringBuilder linkId = new StringBuilder("_").append("datePickerLink");
                datePickerLink.setId(linkId.toString());
                datePickerLink.setAlign("middle");
                datePickerLink.setToolTip(styles[13]);
                if (!calendar.isDisabled()) {
                    datePickerLink.setIcon(styles[14]);
                } else {
                    datePickerLink.setIcon(styles[19]);
                }
                RenderingUtilities.renderComponent(datePickerLink, context);
                comp = datePickerLink;
            }
            writer.write("\n");
            writer.endElement("span");
            writer.write("\n");
            this.renderDatePicker(context, writer, styles, calendar, comp);
            writer.endElement("div");
            writer.writeText("\n", null);
            writer.endElement("td");
            writer.writeText("\n", null);
        }
        this.renderTableEnd(writer);
        writer.writeText("\n", null);
    }

    private void renderDatePicker(FacesContext context, ResponseWriter writer, String[] styles, Calendar calendar, UIComponent datePickerLink) throws IOException {
        CalendarMonth datePicker = calendar.getDatePicker();
        Object value = calendar.getSubmittedValue();
        if (value != null) {
            try {
                Object dO = ConversionUtilities.convertValueToObject(calendar, (String)value, context);
                datePicker.setValue(dO);
            }
            catch (Exception ex) {}
        } else if (calendar.getValue() != null) {
            datePicker.setValue(calendar.getValue());
        }
        datePicker.initCalendarControls(calendar.getJavaScriptObjectName(context));
        RenderingUtilities.renderComponent(datePicker, context);
        this.renderJavaScript(context, calendar, writer, styles, datePickerLink);
    }

    private void renderTableStart(Calendar calendar, String rootStyle, String hiddenStyle, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("table", calendar);
        writer.writeAttribute("border", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("title", "", null);
        writer.writeAttribute("id", calendar.getClientId(context), "id");
        String style = calendar.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", style, "style");
        }
        if ((style = (style = this.getStyleClass(calendar, hiddenStyle)) == null ? rootStyle : style + " " + rootStyle) != null) {
            writer.writeAttribute("class", style, "class");
        }
        writer.writeText("\n", null);
        writer.startElement("tr", calendar);
        writer.writeText("\n", null);
    }

    private void renderCellStart(Calendar calendar, String style, ResponseWriter writer) throws IOException {
        writer.startElement("td", calendar);
        writer.writeAttribute("valign", "top", null);
        writer.writeText("\n", null);
        writer.startElement("span", calendar);
        writer.writeAttribute("class", style, null);
        writer.writeText("\n", null);
    }

    private void renderCellEnd(ResponseWriter writer) throws IOException {
        writer.writeText("\n", null);
        writer.endElement("span");
        writer.writeText("\n", null);
        writer.endElement("td");
        writer.writeText("\n", null);
    }

    private void renderTableEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.writeText("\n", null);
        writer.endElement("table");
        writer.writeText("\n", null);
    }

    private void renderPattern(Calendar calendar, String styleClass, String hiddenStyle, FacesContext context, ResponseWriter writer) throws IOException {
        String hint = calendar.getDateFormatPatternHelp();
        if (hint == null) {
            try {
                String pattern = calendar.getDatePicker().getDateFormatPattern();
                hint = ThemeUtilities.getTheme(context).getMessage("calendar.".concat(pattern));
            }
            catch (MissingResourceException mre) {
                hint = ((SimpleDateFormat)calendar.getDateFormat()).toLocalizedPattern().toLowerCase();
            }
        }
        if (hint != null) {
            writer.startElement("div", calendar);
            String id = calendar.getClientId(context);
            id = id.concat("_pattern");
            writer.writeAttribute("id", id, null);
            String style = styleClass;
            writer.writeAttribute("class", style, null);
            writer.writeText(hint, null);
            writer.endElement("div");
        }
    }

    private void renderJavaScript(FacesContext context, Calendar calendar, ResponseWriter writer, String[] styles, UIComponent datePickerLink) throws IOException {
        int firstDay = calendar.getDatePicker().getCalendar().getFirstDayOfWeek();
        String day = null;
        if (firstDay == 1) {
            day = "0";
        } else if (firstDay == 2) {
            day = "1";
        } else if (firstDay == 6) {
            day = "5";
        } else if (firstDay == 7) {
            day = "6";
        } else if (firstDay == 3) {
            day = "2";
        } else if (firstDay == 4) {
            day = "3";
        } else if (firstDay == 5) {
            day = "4";
        }
        try {
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            String datePickerId = calendar.getDatePicker().getClientId(context);
            json.put("id", calendar.getClientId(context)).put("firstDay", day).put("fieldId", calendar.getClientId(context).concat("_field")).put("patternId", calendar.getClientId(context).concat("_pattern")).put("calendarToggleId", datePickerLink.getClientId(context)).put("datePickerId", datePickerId).put("monthMenuId", calendar.getDatePicker().getMonthMenu().getClientId(context)).put("yearMenuId", calendar.getDatePicker().getYearMenu().getClientId(context)).put("rowId", datePickerId + ":row5").put("showButtonSrc", styles[8]).put("hideButtonSrc", styles[9]).put("dateFormat", calendar.getDatePicker().getDateFormatPattern()).put("dateClass", styles[10]).put("edgeClass", styles[11]).put("selectedClass", styles[15]).put("edgeSelectedClass", styles[16]).put("todayClass", styles[17]).put("hiddenClass", styles[2]);
            buff.append(JavaScriptUtilities.getModule("calendar")).append("\n").append(JavaScriptUtilities.getModuleName("calendar._init")).append("(").append(JSONUtilities.getString(json)).append(");");
            JavaScriptUtilities.renderJavaScript(calendar, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    String[] getStyles(Calendar calendar, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[]{theme.getStyleClass("TEXT_FIELD"), theme.getStyleClass("TEXT_FIELD_DISABLED"), theme.getStyleClass("HIDDEN"), "", "", theme.getStyleClass("CALENDAR_FIELD_IMAGE"), theme.getStyleClass("CALENDAR_FIELD_LABEL"), theme.getStyleClass("HELP_FIELD_TEXT"), theme.getImagePath("CALENDAR_BUTTON"), theme.getImagePath("CALENDAR_BUTTON_FLIP"), theme.getStyleClass("DATE_TIME_LINK"), theme.getStyleClass("DATE_TIME_OTHER_LINK"), null, theme.getMessage("calendar.popupImageAlt"), "CALENDAR_BUTTON", theme.getStyleClass("DATE_TIME_BOLD_LINK"), theme.getStyleClass("DATE_TIME_OTHER_BOLD_LINK"), theme.getStyleClass("DATE_TIME_TODAY_LINK"), theme.getStyleClass("CALENDAR_ROOT_TABLE"), "CALENDAR_BUTTON_DISABLED"};
        return styles;
    }
}

