/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.CommonTasksGroup;
import com.sun.webui.jsf.component.CommonTasksSection;
import com.sun.webui.jsf.component.HelpInline;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTasksSectionRenderer
extends AbstractRenderer {
    private static final String SPACER_IMAGE = "_spacerImg";
    private static final String WHITE_SPACE = "&nbsp;";
    private static final String COLUMN_COUNT = "commonTasks.columnCount";
    private static final String SECTION_TITLE = "commonTasks.sectionTitle";

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String title;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        CommonTasksSection cts = (CommonTasksSection)component;
        Theme theme = ThemeUtilities.getTheme(context);
        int numColumns = 2;
        if (cts.getColumns() > 0) {
            numColumns = cts.getColumns();
        }
        writer.startElement("div", cts);
        writer.writeAttribute("id", cts.getClientId(context), "id");
        String styles = RenderingUtilities.getStyleClasses(context, cts, theme.getStyleClass("CTS_SECTION"));
        if (styles != null) {
            writer.writeAttribute("class", styles, "class");
        }
        if ((styles = cts.getStyle()) != null) {
            writer.writeAttribute("style", styles, "style");
        }
        writer.startElement("table", cts);
        writer.writeAttribute("width", "100%", "width");
        writer.writeAttribute("border", "0", "border");
        writer.writeAttribute("cellpadding", "0", "cellpadding");
        writer.writeAttribute("cellspacing", "0", "cellspacing");
        writer.writeAttribute("title", "", "title");
        if (cts.getTitle() != null) {
            title = cts.getTitle();
        } else {
            title = theme.getMessage(SECTION_TITLE);
            cts.setTitle(title);
        }
        this.renderHeading(title, writer, cts, theme, context);
        writer.endElement("table");
        writer.startElement("table", cts);
        writer.writeAttribute("width", "100%", "width");
        writer.writeAttribute("border", "0", "border");
        writer.writeAttribute("cellpadding", "0", "cellpadding");
        writer.writeAttribute("cellspacing", "0", "cellspacing");
        writer.writeAttribute("title", "", "title");
        this.renderSpacer(writer, cts, theme, numColumns, context);
        writer.startElement("tr", cts);
        writer.startElement("td", cts);
        writer.writeAttribute("valign", "top", "valign");
        this.layoutCommonTasks(cts, theme, context, writer, numColumns);
        writer.endElement("td");
        writer.startElement("td", cts);
        writer.writeAttribute("height", "503", "height");
        this.renderSpacerImage(cts, 503, 1, theme, context, SPACER_IMAGE);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void renderJavascript(Theme theme, ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        block2: {
            try {
                JSONObject json = new JSONObject();
                json.put("id", component.getClientId(context)).put("pic1URL", theme.getImagePath("CTS_RIGHT_TOGGLE_SELECTED")).put("pic2URL", theme.getImagePath("CTS_RIGHT_TOGGLE_OVER")).put("pic3URL", theme.getImagePath("CTS_RIGHT_TOGGLE"));
                StringBuffer buff = new StringBuffer();
                buff.append(JavaScriptUtilities.getModule("commonTasksSection")).append(JavaScriptUtilities.getModuleName("commonTasksSection._init(")).append(JSONUtilities.getString(json)).append(");\n");
                JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
            }
            catch (JSONException e) {
                if (!LogUtil.fineEnabled()) break block2;
                LogUtil.fine(e.getStackTrace().toString());
            }
        }
    }

    protected void renderHeading(String title, ResponseWriter writer, CommonTasksSection cts, Theme theme, FacesContext context) throws IOException {
        writer.startElement("tr", cts);
        writer.writeAttribute("valign", "top", "valign");
        writer.startElement("td", cts);
        writer.writeAttribute("class", theme.getStyleClass("CTS_TOP_BOX"), "class");
        writer.writeAttribute("colspan", "4", "colspan");
        writer.writeAttribute("height", "64", "height");
        writer.startElement("div", cts);
        writer.writeAttribute("class", theme.getStyleClass("CTS_HEADER"), "class");
        writer.writeText(title, null);
        writer.endElement("div");
        UIComponent comp = cts.getHelp(context);
        if (!(comp instanceof HelpInline)) {
            writer.startElement("div", cts);
            writer.writeAttribute("class", theme.getStyleClass("CTS_SECTION_HELP"), "class");
            RenderingUtilities.renderComponent(comp, context);
            writer.endElement("div");
        } else {
            ((HelpInline)comp).setStyleClass(theme.getStyleClass("CTS_SECTION_HELP"));
            RenderingUtilities.renderComponent(comp, context);
        }
        writer.endElement("td");
        writer.endElement("tr");
    }

    protected void renderSpacer(ResponseWriter writer, UIComponent cts, Theme theme, int numColumns, FacesContext context) throws IOException {
        int _spacerWidth = 40;
        int columnWidth = 200;
        int _sepWidth = 9;
        int _initWidth = 5;
        if (numColumns > 1) {
            _spacerWidth /= numColumns - 1;
            columnWidth /= numColumns - 1;
            _sepWidth /= numColumns - 1;
            _initWidth /= numColumns - 1;
        }
        String percent = "%";
        String spacerWidth = _spacerWidth + percent;
        String sepWidth = _sepWidth + percent;
        String initWidth = _initWidth + percent;
        writer.startElement("tr", cts);
        if (numColumns == 1) {
            numColumns = 2;
        }
        for (int i = 0; i < numColumns; ++i) {
            writer.startElement("td", cts);
            writer.writeAttribute("width", spacerWidth, "width");
            this.renderSpacerImage(cts, 1, columnWidth, theme, context, SPACER_IMAGE + i);
            writer.endElement("td");
            writer.startElement("td", cts);
            if (i == numColumns - 1) {
                writer.writeAttribute("width", initWidth, "width");
            } else {
                writer.writeAttribute("width", sepWidth, "width");
            }
            writer.write(WHITE_SPACE);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    protected void renderSpacerImage(UIComponent component, int height, int width, Theme theme, FacesContext context, String id) throws IOException {
        Icon img = ThemeUtilities.getIcon(theme, "CTS_SPACER_IMAGE");
        img.setParent(component);
        img.setId(id);
        RenderingUtilities.renderComponent(img, context);
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void layoutCommonTasks(CommonTasksSection cts, Theme theme, FacesContext context, ResponseWriter writer, int numColumns) throws IOException {
        List<UIComponent> children = cts.getChildren();
        Iterator<UIComponent> itr = children.iterator();
        int commonTaskCount = cts.getCommonTaskCount();
        int cnt = numColumns;
        int separator = (int)Math.ceil((double)commonTaskCount / (double)numColumns);
        int count = 0;
        this.renderJavascript(theme, writer, cts, context);
        while (itr.hasNext()) {
            UIComponent obj = itr.next();
            UIComponent comp = obj;
            if (!comp.isRendered()) continue;
            if (cts.getCommonTaskCount() <= numColumns && count > 0) {
                writer.endElement("td");
                writer.startElement("td", cts);
                writer.write(WHITE_SPACE);
                writer.endElement("td");
                writer.startElement("td", cts);
                writer.writeAttribute("valign", "top", "valign");
            } else if ((count >= separator || comp instanceof CommonTasksGroup && count + ((CommonTasksGroup)comp).getChildCount() > separator && count > 0) && cnt > 1) {
                --cnt;
                writer.endElement("td");
                writer.startElement("td", cts);
                writer.write(WHITE_SPACE);
                writer.endElement("td");
                writer.startElement("td", cts);
                writer.writeAttribute("valign", "top", "valign");
                int tmp = numColumns - 1;
                separator = (int)Math.ceil((double)(commonTaskCount - count) / (double)tmp);
                count = 0;
            }
            RenderingUtilities.renderComponent(comp, context);
            if (comp instanceof CommonTasksGroup) {
                count += comp.getChildCount();
                continue;
            }
            ++count;
        }
    }
}

