/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.TextArea;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class FieldRenderer
extends Renderer {
    public static final String[] STRING_ATTRIBUTES = new String[]{"onBlur", "onChange", "onClick", "onDblClick", "onFocus", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyDown", "onKeyPress", "onKeyUp", "onSelect"};
    public static final String SPACER_ID = "_spacer";
    private static final boolean DEBUG = false;

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!(component instanceof Field)) {
            return;
        }
        Field field = (Field)component;
        if (field.isDisabled() || field.isReadOnly()) {
            return;
        }
        String id = field.getClientId(context);
        if (field instanceof ComplexComponent) {
            id = field.getLabeledElementId(context);
        }
        if (id == null) {
            return;
        }
        String value = null;
        Map<String, String> params = context.getExternalContext().getRequestParameterMap();
        String valueObject = params.get(id);
        if (valueObject != null) {
            value = valueObject;
            if (field.isTrim()) {
                value = value.toString().trim();
            }
        }
        field.setSubmittedValue(value);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Field)) {
            Object[] params = new Object[]{component.toString(), this.getClass().getName(), Field.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        this.renderField(context, (Field)component, "text", this.getStyles(context));
    }

    public boolean renderField(FacesContext context, Field component, String type, String[] styles) throws IOException {
        UIComponent label;
        String id = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        writer.writeAttribute("id", id, "id");
        String style = component.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", style, "style");
        }
        if ((style = this.getStyleClass(component, styles[2])) != null) {
            writer.writeAttribute("class", style, "class");
        }
        if ((label = component.getLabelComponent(context, styles[3])) != null) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(label, context);
            writer.writeText("\n", null);
            Theme theme = ThemeUtilities.getTheme(context);
            Icon icon = ThemeUtilities.getIcon(theme, "DOT");
            icon.setParent(component);
            icon.setId(component.getId().concat(SPACER_ID));
            icon.setHeight(1);
            icon.setWidth(10);
            RenderingUtilities.renderComponent(icon, context);
            writer.writeText("\n", null);
        }
        if (component.isReadOnly()) {
            UIComponent text = component.getReadOnlyComponent(context);
            RenderingUtilities.renderComponent(text, context);
        } else {
            if (component instanceof ComplexComponent) {
                id = component.getLabeledElementId(context);
            }
            this.renderInput(component, type, id, false, styles, context, writer);
        }
        writer.writeText("\n", null);
        writer.endElement("span");
        return true;
    }

    protected void renderInput(Field component, String type, String id, boolean renderUserStyles, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        int tabIndex;
        String toolTip;
        int maxlength;
        if (component instanceof TextArea) {
            int columns;
            writer.startElement("textarea", component);
            int rows = ((TextArea)component).getRows();
            if (rows > 0) {
                writer.writeAttribute("rows", String.valueOf(rows), "rows");
            }
            if ((columns = component.getColumns()) > 0) {
                writer.writeAttribute("cols", String.valueOf(columns), "columns");
            }
        } else {
            writer.startElement("input", component);
            writer.writeAttribute("type", type, null);
            int columns = component.getColumns();
            if (columns > 0) {
                writer.writeAttribute("size", String.valueOf(columns), "columns");
            }
        }
        writer.writeAttribute("id", id, null);
        writer.writeAttribute("name", id, null);
        if (component.isDisabled()) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        if ((maxlength = component.getMaxLength()) > 0) {
            writer.writeAttribute("maxlength", String.valueOf(maxlength), "maxLength");
        }
        if ((toolTip = component.getToolTip()) != null && toolTip.length() > 0) {
            writer.writeAttribute("title", toolTip, "toolTip");
        }
        if ((tabIndex = component.getTabIndex()) > 0) {
            writer.writeAttribute("tabindex", String.valueOf(tabIndex), "tabIndex");
        }
        RenderingUtilities.writeStringAttributes(component, writer, STRING_ATTRIBUTES);
        String styleClass = null;
        styleClass = component.isDisabled() ? styles[1] : styles[0];
        String style = null;
        if (renderUserStyles) {
            String compStyleClass = this.getStyleClass(component, styles[2]);
            if (compStyleClass != null) {
                styleClass = compStyleClass + " " + styleClass;
            }
            if ((style = component.getStyle()) != null && style.length() == 0) {
                style = null;
            }
        }
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", style, null);
        }
        if (component.getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, component.getValue());
        }
        String value = component.getValueAsString(context);
        if (component instanceof TextArea) {
            writer.writeText(value, "value");
            writer.endElement("textarea");
        } else {
            if (value != null) {
                writer.writeAttribute("value", value, "value");
            }
            writer.endElement("input");
        }
    }

    protected String getStyleClass(Field component, String hiddenStyle) {
        String style = component.getStyleClass();
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!component.isVisible()) {
            style = style == null ? hiddenStyle : style + " " + hiddenStyle;
        }
        return style;
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    String[] getStyles(FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[]{theme.getStyleClass("TEXT_FIELD"), theme.getStyleClass("TEXT_FIELD_DISABLED"), theme.getStyleClass("HIDDEN"), ""};
        return styles;
    }
}

