/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Form;
import com.sun.webui.jsf.model.Markup;
import com.sun.webui.jsf.model.ScriptMarkup;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class FormRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"enctype", "accessKey", "onReset", "onSubmit", "target"};
    private static final String SUBMISSION_COMPONENT_HIDDEN_FIELD = "_submissionComponentId";
    private static final String FORM_HIDDEN_FIELD = "_hidden";

    public void decode(FacesContext context, UIComponent component) {
        Form.VirtualFormDescriptor vfd;
        String hiddenFieldClientId;
        String submissionComponentId;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Form form = (Form)component;
        Map<String, String> map = context.getExternalContext().getRequestParameterMap();
        boolean b = map.containsKey(form.getClientId(context) + FORM_HIDDEN_FIELD);
        form.setSubmitted(b);
        if (LogUtil.fineEnabled()) {
            LogUtil.fine("Form(id=" + form.getId() + ",submitted=" + form.isSubmitted() + ")");
        }
        if ((submissionComponentId = map.get(hiddenFieldClientId = SUBMISSION_COMPONENT_HIDDEN_FIELD)) != null && (vfd = form.getVirtualFormComponentSubmits(submissionComponentId)) != null) {
            form.setSubmittedVirtualForm(vfd);
        }
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Form form = (Form)component;
        if (LogUtil.fineEnabled()) {
            LogUtil.fine("Form(id=" + form.getId() + ")");
        }
        writer.startElement("form", form);
        form.restoreNonParticipatingSubmittedValues();
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Form form = (Form)component;
        this.addCoreAttributes(context, form, writer, "form");
        writer.writeAttribute("method", "post", null);
        writer.writeAttribute("action", this.action(context), null);
        FormRenderer.addStringAttributes(context, form, writer, EVENTS_ATTRIBUTES);
        FormRenderer.addStringAttributes(context, form, writer, stringAttributes);
        if (!form.isAutoComplete()) {
            writer.writeAttribute("autocomplete", "off", null);
        }
        writer.write("\n");
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Form form = (Form)component;
        Object list = null;
        boolean n = false;
        writer.write("\n");
        RenderingUtilities.renderHiddenField(component, writer, form.getClientId(context) + FORM_HIDDEN_FIELD, form.getClientId(context) + FORM_HIDDEN_FIELD);
        writer.write("\n");
        context.getApplication().getViewHandler().writeState(context);
        writer.write("\n");
        writer.endElement("form");
        writer.write("\n");
        if (LogUtil.finestEnabled()) {
            LogUtil.finest("  Rendering completed");
        }
    }

    private String action(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(url);
    }

    private String function(FacesContext context, Form form, String handler) {
        String clientId = form.getClientId(context);
        return handler + "_" + clientId.replace(':', '_');
    }

    private Markup handler(FacesContext context, Form form, String name, List list) {
        String code = null;
        ScriptMarkup markup = new ScriptMarkup();
        markup.writeRaw("function " + this.function(context, form, name) + "(form) {\n", null);
        code = (String)form.getAttributes().get(name);
        if (code != null) {
            markup.writeRaw("    ", null);
            markup.writeRaw(code, null);
            if (!code.endsWith(";")) {
                markup.writeRaw(";", null);
            }
            markup.writeRaw("\n", null);
        }
        for (int i = 0; i < list.size(); ++i) {
            code = ((String)list.get(i)).trim();
            markup.writeRaw("    ", null);
            markup.writeRaw(code, null);
            if (!code.endsWith(";")) {
                markup.writeRaw(";", null);
            }
            markup.writeRaw("\n", null);
        }
        markup.writeRaw("    return true;\n", null);
        markup.writeRaw("}\n", null);
        return markup;
    }
}

