/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Head;
import com.sun.webui.jsf.component.util.Util;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;

public class HeadRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"profile"};

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.startElement("head", component);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Head head = (Head)component;
        if (!RenderingUtilities.isPortlet(context)) {
            HeadRenderer.addStringAttributes(context, component, writer, stringAttributes);
            if (head.isMeta()) {
                this.renderMetaTag("no-cache", "Pragma", writer, head);
                this.renderMetaTag("no-cache", "Cache-Control", writer, head);
                this.renderMetaTag("no-store", "Cache-Control", writer, head);
                this.renderMetaTag("max-age=0", "Cache-Control", writer, head);
                this.renderMetaTag("1", "Expires", writer, head);
            }
            UIComponent titleFacet = head.getFacets().get("title");
            writer.write("\n");
            writer.startElement("title", head);
            if (titleFacet != null) {
                RenderingUtilities.renderComponent(titleFacet, context);
            } else {
                String title = head.getTitle();
                if (title != null) {
                    writer.write(title);
                }
            }
            writer.endElement("title");
            if (head.isDefaultBase()) {
                writer.write("\n");
                writer.startElement("base", head);
                writer.writeURIAttribute("href", Util.getBase(context), null);
                writer.endElement("base");
            }
            JavaScriptUtilities.setDebug(head.isDebug());
            JavaScriptUtilities.setJsfx(head.isJsfx());
            JavaScriptUtilities.setParseOnLoad(head.isParseOnLoad());
            JavaScriptUtilities.setStyleSheet(head.isStyleSheet());
            JavaScriptUtilities.setWebuiAll(head.isWebuiAll());
            JavaScriptUtilities.setWebuiJsfx(head.isWebuiJsfx());
            Theme theme = ThemeUtilities.getTheme(context);
            if (head.isStyleSheet() && Beans.isDesignTime()) {
                RenderingUtilities.renderStyleSheetLink(head, theme, context, writer);
                JavaScriptUtilities.setStyleSheet(false);
            }
            if (head.isJavaScript()) {
                try {
                    JavaScriptUtilities.renderBootstrap(component, writer);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.endElement("head");
        }
    }

    private void renderMetaTag(String content, String httpEquivalent, ResponseWriter writer, Head head) throws IOException {
        writer.write("\n");
        writer.startElement("meta", head);
        writer.writeAttribute("content", content, null);
        writer.writeAttribute("http-equiv", httpEquivalent, null);
        writer.endElement("meta");
    }
}

