/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.model.list.EndGroup;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.model.list.StartGroup;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public abstract class ListRendererBase
extends Renderer {
    private static final boolean DEBUG = false;
    public static final String[] STRING_ATTRIBUTES = new String[]{"onBlur", "onClick", "onDblClick", "onFocus", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp", "onSelect"};
    protected static final String SEPARATOR = "|";

    void renderListComponent(ListSelector component, FacesContext context, String[] styles) throws IOException {
        boolean readonly;
        UIComponent label = component.getLabelComponent();
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        this.renderOpenEncloser(component, context, "span", styles[8]);
        if (label != null) {
            writer.writeText("\n", null);
            if (!component.isLabelOnTop() && component.getRows() > 1) {
                Map<String, Object> attributes = label.getAttributes();
                Object styleClass = attributes.get("styleClass");
                if (styleClass == null) {
                    attributes.put("styleClass", styles[9]);
                } else if (styleClass.toString().indexOf(styles[9]) == -1) {
                    attributes.put("styleClass", styleClass + " " + styles[9]);
                }
            }
            RenderingUtilities.renderComponent(label, context);
            writer.writeText("\n", null);
            if (component.isLabelOnTop()) {
                writer.startElement("br", component);
                writer.endElement("br");
                writer.writeText("\n", null);
            }
            writer.writeText("\n", null);
        }
        if (readonly = component.isReadOnly()) {
            UIComponent value = component.getReadOnlyValueComponent();
            if (label == null) {
                value.getAttributes().put("style", component.getStyle());
                value.getAttributes().put("styleClass", component.getStyleClass());
            }
            RenderingUtilities.renderComponent(value, context);
        } else {
            if (component instanceof ComplexComponent) {
                id = component.getLabeledElementId(context);
            }
            this.recordRenderedValue(component);
            this.renderList(component, id, context, styles);
        }
        context.getResponseWriter().endElement("span");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderOpenEncloser(ListManager component, FacesContext context, String element, String hiddenStyle) throws IOException {
        String id = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText("\n", null);
        writer.startElement(element, (UIComponent)((Object)component));
        writer.writeAttribute("id", id, "id");
        String style = component.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", style, "style");
        }
        style = component.getStyleClass();
        if (component.isVisible()) {
            if (style != null && style.length() > 0) {
                writer.writeAttribute("class", style, "class");
            }
        } else {
            style = style == null ? hiddenStyle : style + " " + hiddenStyle;
            writer.writeAttribute("class", style, "class");
        }
        writer.writeText("\n", null);
    }

    protected void renderHiddenValue(UIComponent component, FacesContext context, ResponseWriter writer, String hiddenStyle) throws IOException {
        ListManager listManager = (ListManager)((Object)component);
        this.recordRenderedValue(component);
        String hiddenID = component.getClientId(context).concat("_list_value");
        String hiddenLabelID = component.getClientId(context).concat("_hiddenlabel");
        String[] values = listManager.getValueAsStringArray(context);
        writer.startElement("label", component);
        writer.writeAttribute("id", hiddenLabelID, null);
        writer.writeAttribute("for", hiddenID, "for");
        writer.writeAttribute("class", hiddenStyle, null);
        writer.endElement("label");
        writer.startElement("select", component);
        writer.writeAttribute("id", hiddenID, null);
        writer.writeAttribute("name", hiddenID, null);
        writer.writeAttribute("multiple", "true", null);
        writer.writeAttribute("class", hiddenStyle, null);
        writer.writeText("\n", null);
        for (int counter = 0; counter < values.length; ++counter) {
            writer.startElement("option", component);
            writer.writeAttribute("selected", "selected", null);
            writer.writeAttribute("value", values[counter], null);
            writer.writeText(values[counter], null);
            writer.endElement("option");
            writer.writeText("\n", null);
        }
        writer.endElement("select");
    }

    protected void renderList(ListManager listManager, String id, FacesContext context, String[] styles) throws IOException {
        String tooltip;
        int size;
        String styleClass = styles[1];
        if (listManager.isDisabled()) {
            styleClass = styles[2];
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", (UIComponent)((Object)listManager));
        this.renderSelectStyle(listManager, writer);
        writer.writeAttribute("class", styleClass, null);
        writer.writeAttribute("id", id, null);
        if (listManager.mainListSubmits()) {
            writer.writeAttribute("name", id, null);
        }
        if ((size = listManager.getRows()) < 1) {
            size = 12;
        }
        writer.writeAttribute("size", String.valueOf(size), null);
        if (listManager.isMultiple()) {
            writer.writeAttribute("multiple", "multiple", null);
        }
        if (listManager.isDisabled()) {
            writer.writeAttribute("disabled", "disabled", "disabled");
        }
        if ((tooltip = listManager.getToolTip()) != null) {
            writer.writeAttribute("title", tooltip, null);
        }
        writer.writeAttribute("onchange", styles[0], null);
        int tabindex = listManager.getTabIndex();
        if (tabindex > 0 && tabindex < Short.MAX_VALUE) {
            writer.writeAttribute("tabindex", String.valueOf(tabindex), "tabindex");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)((Object)listManager), writer, STRING_ATTRIBUTES);
        writer.writeText("\n", null);
        this.renderListOptions((UIComponent)((Object)listManager), context, listManager.getListItems(context, true), writer, styles);
        writer.endElement("select");
        writer.writeText("\n", null);
    }

    protected String getOnChangeJavaScript(ListManager component, String functionName, FacesContext context) {
        String script = component.getOnChange();
        String id = component.getClientId(context);
        StringBuffer onchangeBuffer = new StringBuffer(200);
        if (script != null) {
            onchangeBuffer.append(script).append(";");
        }
        onchangeBuffer.append(functionName);
        onchangeBuffer.append("('");
        onchangeBuffer.append(id);
        onchangeBuffer.append("'); ");
        onchangeBuffer.append(" return false;");
        return onchangeBuffer.toString();
    }

    void renderListOptions(UIComponent component, FacesContext context, Iterator optionsIterator, ResponseWriter writer, String[] styles) throws IOException {
        Object option = null;
        boolean noSeparator = true;
        while (optionsIterator.hasNext()) {
            option = optionsIterator.next();
            if (option instanceof Separator) {
                this.renderSeparator(component, writer, styles[7]);
                continue;
            }
            if (option instanceof StartGroup) {
                StartGroup group = option;
                if (!noSeparator) {
                    this.renderSeparator(component, writer, styles[7]);
                }
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", group.getLabel(), null);
                writer.writeAttribute("class", styles[6], null);
                writer.write("\n");
                noSeparator = true;
                continue;
            }
            if (option instanceof EndGroup) {
                writer.endElement("optgroup");
                writer.write("\n");
                if (optionsIterator.hasNext()) {
                    this.renderSeparator(component, writer, styles[7]);
                }
                noSeparator = true;
                continue;
            }
            this.renderListOption(component, context, option, writer, styles);
            noSeparator = false;
        }
    }

    void renderListOption(UIComponent list, FacesContext context, ListItem listItem, ResponseWriter writer, String[] styles) throws IOException {
        String styleClass = styles[3];
        if (listItem.isDisabled()) {
            styleClass = styles[4];
        } else if (listItem.isSelected()) {
            styleClass = styles[5];
        }
        writer.writeText("\t", null);
        writer.startElement("option", list);
        writer.writeAttribute("class", styleClass, null);
        String itemValue = listItem.getValue();
        if (itemValue != null) {
            writer.writeAttribute("value", itemValue, null);
        }
        if (listItem.isDisabled()) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        if (listItem.isSelected()) {
            writer.writeAttribute("selected", "selected", null);
        }
        this.renderLabel(context, writer, listItem.getLabel(), listItem.isEscape(), listItem.isTitle());
        writer.endElement("option");
        writer.writeText("\n", null);
    }

    void renderSeparator(UIComponent component, ResponseWriter writer, String style) throws IOException {
        if (!(component instanceof ListSelector)) {
            return;
        }
        ListSelector selector = (ListSelector)component;
        if (!selector.isSeparators()) {
            return;
        }
        writer.writeText("\t", null);
        writer.startElement("option", component);
        writer.writeAttribute("class", style, null);
        writer.writeAttribute("disabled", "disabled", null);
        int numEms = selector.getSeparatorLength();
        StringBuffer labelBuffer = new StringBuffer();
        for (int em = 0; em < numEms; ++em) {
            labelBuffer.append("-");
        }
        writer.writeText(labelBuffer.toString(), null);
        writer.endElement("option");
        writer.writeText("\n", null);
    }

    void renderReadOnlyList(ListManager component, UIComponent label, FacesContext context, String hiddenStyle) throws IOException {
        UIComponent value = component.getReadOnlyValueComponent();
        this.renderOpenEncloser(component, context, "span", hiddenStyle);
        if (label != null) {
            RenderingUtilities.renderComponent(label, context);
        }
        RenderingUtilities.renderComponent(value, context);
        context.getResponseWriter().endElement("span");
    }

    private String getStyleClass(ListManager component, String hiddenStyle) {
        String style = component.getStyleClass();
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!component.isVisible()) {
            style = style == null ? hiddenStyle : style + " " + hiddenStyle;
        }
        return style;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (((ListManager)((Object)component)).isReadOnly()) {
            return;
        }
        String id = component.getClientId(context);
        if (component instanceof ComplexComponent) {
            id = ((ComplexComponent)((Object)component)).getLabeledElementId(context);
        }
        this.decode(context, component, id);
    }

    protected void decode(FacesContext context, UIComponent component, String id) {
        ListManager lmComponent = (ListManager)((Object)component);
        if (lmComponent.isReadOnly()) {
            return;
        }
        Map<String, String[]> params = context.getExternalContext().getRequestParameterValuesMap();
        String[] values = null;
        String[] p = params.get(id);
        values = p == null ? new String[]{} : p;
        if (values.length > 1) {
            ArrayList<String> newParams = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                if ("com_sun_webui_jsf_NONESELECTED".equals(values[i])) continue;
                newParams.add(values[i]);
            }
            values = newParams.toArray(new String[newParams.size()]);
        } else if (values.length == 1 && "com_sun_webui_jsf_NONESELECTED".equals(values[0])) {
            return;
        }
        if (values.length > 0 || !lmComponent.isDisabled()) {
            lmComponent.setSubmittedValue(values);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    String[] getUserInput(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        Map<String, String[]> params = context.getExternalContext().getRequestParameterValuesMap();
        String[] values = null;
        if (params.containsKey(id)) {
            values = params.get(id);
        }
        if (values == null) {
            values = new String[]{};
        }
        return values;
    }

    void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    private void recordRenderedValue(UIComponent component) {
        if (component instanceof EditableValueHolder && ((EditableValueHolder)((Object)component)).getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, ((EditableValueHolder)((Object)component)).getValue());
        }
    }

    protected void renderSelectStyle(ListManager component, ResponseWriter writer) throws IOException {
        String width = component.getWidth();
        if (width != null) {
            StringBuilder sb = new StringBuilder("width");
            sb.append(':').append(width).append(';');
            writer.writeAttribute("style", sb.toString(), null);
        }
    }

    protected void renderLabel(FacesContext context, ResponseWriter writer, String label, boolean escape, boolean isTitle) throws IOException {
        if (isTitle) {
            this.renderTitleLabel(context, writer, label, escape);
            return;
        }
        if (label == null) {
            writer.writeText("", null);
            return;
        }
        if (escape) {
            writer.writeText(label, null);
        } else {
            writer.write(label);
        }
    }

    protected void renderTitleLabel(FacesContext context, ResponseWriter writer, String titleLabel, boolean escape) throws IOException {
        String tmp = this.getMessage(context, "ListSelector.titleOptionLabel", new Object[]{titleLabel == null ? "" : titleLabel});
        if (tmp != null) {
            titleLabel = tmp;
        }
        if (!escape || !ThemeUtilities.getTheme(context).getMessageBoolean("ListSelector.titleOptionLabelEscape", true)) {
            writer.write(titleLabel);
        } else {
            writer.writeText(titleLabel, null);
        }
    }

    private String getMessage(FacesContext context, String key, Object[] params) {
        String msg;
        block2: {
            Theme theme = ThemeUtilities.getTheme(context);
            msg = null;
            try {
                msg = params != null ? theme.getMessage(key, params) : theme.getMessage(key);
            }
            catch (Exception e) {
                if (!LogUtil.finestEnabled()) break block2;
                LogUtil.finest("ListRendererBase.getMessage: Can't get message key" + key, e);
            }
        }
        return msg != null && msg.length() != 0 ? msg : null;
    }
}

