/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.PageAlert;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class PageAlertRenderer
extends AbstractRenderer {
    public static final String PAGETITLE_BUTTON_FACET = "pageButtons";

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null || writer == null) {
            throw new NullPointerException();
        }
        PageAlert pagealert = (PageAlert)component;
        writer.startElement("div", component);
        this.addCoreAttributes(context, component, writer, null);
        this.renderAlert(context, component, writer);
        this.renderSeparator(context, component, writer);
        this.renderButtons(context, component, writer);
        writer.endElement("div");
    }

    protected void renderAlertSummary(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        String summary = pagealert.getSummary();
        if (summary == null || summary.trim().length() == 0) {
            return;
        }
        writer.startElement("div", pagealert);
        String style = theme.getStyleClass("ALERT_HEADER_DIV");
        RenderingUtilities.renderStyleClass(context, writer, component, style);
        writer.startElement("span", pagealert);
        style = theme.getStyleClass("ALERT_HEADER_TXT");
        writer.writeAttribute("class", style, null);
        this.renderFormattedMessage(writer, component, context, summary);
        writer.endElement("span");
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderAlertDetail(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        String detail = pagealert.getDetail();
        if (detail == null || detail.trim().length() == 0) {
            return;
        }
        writer.startElement("div", pagealert);
        String style = theme.getStyleClass("ALERT_MESSAGE_DIV");
        writer.writeAttribute("class", style, null);
        writer.startElement("span", pagealert);
        style = theme.getStyleClass("ALERT_MESSAGE_TEXT");
        writer.writeAttribute("class", style, null);
        this.renderFormattedMessage(writer, component, context, detail);
        writer.endElement("span");
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderAlertIcon(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        writer.startElement("table", component);
        writer.writeAttribute("title", "", null);
        writer.writeAttribute("border", "0", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        writer.writeAttribute("width", "100%", null);
        writer.startElement("tr", component);
        writer.startElement("td", component);
        writer.startElement("div", component);
        UIComponent titleFacet = pagealert.getFacet("pageAlertTitle");
        if (titleFacet == null) {
            String style = theme.getStyleClass("TITLE_TEXT_DIV");
            writer.writeAttribute("class", style, null);
            writer.startElement("span", component);
            style = theme.getStyleClass("TITLE_TEXT");
            writer.writeAttribute("class", style, null);
            UIComponent image = pagealert.getPageAlertImage();
            RenderingUtilities.renderComponent(image, context);
            writer.write(pagealert.getSafeTitle());
            writer.endElement("span");
        } else {
            RenderingUtilities.renderComponent(titleFacet, context);
        }
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    protected void renderAlert(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderAlertIcon(context, component, theme, writer);
        this.renderAlertSummary(context, component, theme, writer);
        this.renderAlertDetail(context, component, theme, writer);
        UIComponent inputComponent = pagealert.getPageAlertInput();
        if (inputComponent != null) {
            writer.startElement("div", pagealert);
            String style = theme.getStyleClass("ALERT_FORM_DIV");
            RenderingUtilities.renderStyleClass(context, writer, component, style);
            RenderingUtilities.renderComponent(inputComponent, context);
            writer.endElement("div");
            writer.writeText("\n", null);
        }
    }

    private void renderSeparator(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        PageAlert pageAlert = (PageAlert)component;
        UIComponent separator = pageAlert.getPageAlertSeparator();
        RenderingUtilities.renderComponent(separator, context);
    }

    private void renderButtons(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        UIComponent buttonFacet = pagealert.getPageAlertButtons();
        if (buttonFacet == null) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("table", pagealert);
        writer.writeAttribute("border", "0", null);
        writer.writeAttribute("width", "100%", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        writer.startElement("tr", pagealert);
        String style = theme.getStyleClass("TITLE_BUTTON_BOTTOM_DIV");
        writer.startElement("td", pagealert);
        writer.writeAttribute("align", "right", null);
        writer.writeAttribute("nowrap", "nowrap", null);
        writer.startElement("div", pagealert);
        writer.writeAttribute("class", style, null);
        RenderingUtilities.renderComponent(buttonFacet, context);
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void renderFormattedMessage(ResponseWriter writer, UIComponent component, FacesContext context, String msg) throws IOException {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            parameterList.add(((UIParameter)kid).getValue());
        }
        String message = null;
        message = parameterList.size() > 0 ? MessageFormat.format(msg, parameterList.toArray(new Object[parameterList.size()])) : msg;
        if (message != null) {
            PageAlert pa = (PageAlert)component;
            if (!pa.isEscape()) {
                writer.write(message);
            } else {
                writer.writeText(message, "message");
            }
        }
    }
}

