/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Tab;
import com.sun.webui.jsf.component.TabSet;
import com.sun.webui.jsf.renderkit.html.HyperlinkRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class TabRenderer
extends HyperlinkRenderer {
    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        super.renderStart(context, component, writer);
        UIComponent parent = component.getParent();
        if (!(parent instanceof Tab) && !(parent instanceof TabSet) && LogUtil.infoEnabled()) {
            LogUtil.info(TabRenderer.class, "WEBUI0006", new String[]{component.getId()});
        }
    }

    protected void finishRenderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Tab tab = (Tab)component;
        int tabIndex = tab.getTabIndex();
        if (tabIndex >= 0) {
            writer.writeAttribute("tabIndex", Integer.toString(tabIndex), null);
        }
        super.finishRenderAttributes(context, component, writer);
    }

    protected String getStyles(FacesContext context, UIComponent component) {
        String text;
        Object value;
        Tab link = (Tab)component;
        StringBuffer sb = new StringBuffer(200);
        Theme theme = ThemeUtilities.getTheme(context);
        if (link.isDisabled()) {
            sb.append(" ");
            sb.append(theme.getStyleClass("LINK_DISABLED"));
        }
        if ((value = link.getText()) != null && (text = ConversionUtilities.convertValueToString(link, value)).length() <= 6) {
            sb.append(" ");
            sb.append(theme.getStyleClass("TAB_PADDING"));
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        String paramId = super.getSubmittedParameterId(context, component);
        String submittedValue = context.getExternalContext().getRequestParameterMap().get(paramId);
        if (submittedValue != null) {
            Tab selectedTab = (Tab)component;
            while (selectedTab.getTabChildCount() > 0) {
                String previousSelectedTabId = selectedTab.getSelectedChildId();
                List<Tab> childrenTabs = selectedTab.getTabChildren();
                selectedTab = childrenTabs.get(0);
                for (Tab childTab : childrenTabs) {
                    if (childTab.getId() == null || !childTab.getId().equals(previousSelectedTabId)) continue;
                    selectedTab = childTab;
                }
            }
            TabSet tabSet = Tab.getTabSet(selectedTab);
            tabSet.setSubmittedValue(selectedTab.getId());
        }
    }
}

