/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableHeader;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.FocusManager;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TableHeaderRenderer
extends Renderer {
    private static final String[] stringAttributes = new String[]{"abbr", "align", "axis", "bgColor", "char", "charOff", "dir", "headers", "height", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "scope", "style", "valign", "width"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TableHeader header = (TableHeader)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, header, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableHeader header = (TableHeader)component;
        ResponseWriter writer = context.getResponseWriter();
        if (header.isGroupHeader()) {
            this.renderGroupHeader(context, header, writer);
        } else if (header.isSelectHeader()) {
            this.renderSelectHeader(context, header, writer);
        } else if (header.isSortHeader()) {
            this.renderSortHeader(context, header, writer);
        } else {
            this.renderColumnHeader(context, header, writer);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TableHeader header = (TableHeader)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagEnd(context, header, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderColumnHeader(FacesContext context, TableHeader component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderColumnHeader", "Cannot render column header, TableHeader is null");
            return;
        }
        TableColumn col = component.getTableColumnAncestor();
        UIComponent uIComponent = facet = col != null ? col.getFacet("header") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            String styleClass;
            TableColumn parent = col != null ? col.getTableColumnAncestor() : null;
            Iterator kids = col != null ? col.getTableColumnChildren() : null;
            String string = styleClass = kids != null && kids.hasNext() ? "TABLE_MULTIPLE_HEADER_TEXT" : "TABLE_HEADER_TEXT";
            if (parent != null) {
                writer.writeText("\n", null);
                writer.startElement("table", component);
                writer.writeAttribute("class", this.getTheme().getStyleClass("TABLE_HEADER_TABLE"), null);
                writer.writeAttribute("border", "0", null);
                writer.writeAttribute("cellpadding", "0", "cellPadding");
                writer.writeAttribute("cellspacing", "0", "cellSpacing");
                writer.writeText("\n", null);
                writer.startElement("tr", component);
                writer.writeText("\n", null);
                writer.startElement("td", component);
                writer.startElement("span", component);
                writer.writeAttribute("class", this.getTheme().getStyleClass(styleClass), null);
                if (col != null && col.getHeaderText() != null) {
                    writer.writeText(col.getHeaderText(), null);
                }
                writer.endElement("span");
                writer.endElement("td");
                writer.endElement("tr");
                writer.endElement("table");
            } else {
                writer.startElement("span", component);
                writer.writeAttribute("class", this.getTheme().getStyleClass(styleClass), null);
                if (col != null && col.getHeaderText() != null) {
                    writer.writeText(col.getHeaderText(), null);
                }
                writer.endElement("span");
            }
        }
    }

    protected void renderSelectHeader(FacesContext context, TableHeader component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderSelectHeader", "Cannot render select header, TableHeader is null");
            return;
        }
        TableColumn col = component.getTableColumnAncestor();
        UIComponent uIComponent = facet = col != null ? col.getFacet("header") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            writer.writeText("\n", null);
            writer.startElement("table", component);
            writer.writeAttribute("class", this.getTheme().getStyleClass("TABLE_HEADER_TABLE"), null);
            writer.writeAttribute("border", "0", null);
            writer.writeAttribute("cellpadding", "0", "cellPadding");
            writer.writeAttribute("cellspacing", "0", "cellSpacing");
            writer.writeText("\n", null);
            writer.startElement("tr", component);
            writer.writeText("\n", null);
            writer.startElement("td", component);
            writer.writeAttribute("align", component.getAlign(), null);
            RenderingUtilities.renderComponent(component.getSelectSortButton(), context);
            writer.endElement("td");
            UIComponent child = null;
            if (component.getSortLevel() > 0) {
                child = component.getToggleSortButton();
            } else if (component.getSortCount() > 0) {
                child = component.getAddSortButton();
            }
            if (child != null) {
                writer.writeText("\n", null);
                writer.startElement("td", component);
                RenderingUtilities.renderComponent(child, context);
                writer.endElement("td");
                this.setSortFocus(context, component, child);
            }
            writer.endElement("tr");
            writer.endElement("table");
        }
    }

    protected void renderSortHeader(FacesContext context, TableHeader component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderSortHeader", "Cannot render sort header, TableHeader is null");
            return;
        }
        TableColumn col = component.getTableColumnAncestor();
        UIComponent uIComponent = facet = col != null ? col.getFacet("header") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            writer.writeText("\n", null);
            writer.startElement("table", component);
            writer.writeAttribute("class", this.getTheme().getStyleClass("TABLE_HEADER_TABLE"), null);
            writer.writeAttribute("border", "0", null);
            writer.writeAttribute("cellpadding", "0", "cellPadding");
            writer.writeAttribute("cellspacing", "0", "cellSpacing");
            writer.writeText("\n", null);
            writer.startElement("tr", component);
            if (col != null && col.getHeaderText() != null) {
                writer.writeText("\n", null);
                writer.startElement("td", component);
                writer.writeAttribute("align", component.getAlign(), null);
                RenderingUtilities.renderComponent(component.getPrimarySortLink(), context);
                writer.endElement("td");
            }
            UIComponent child = null;
            child = component.getSortLevel() > 0 ? component.getToggleSortButton() : (component.getSortCount() > 0 ? component.getAddSortButton() : component.getPrimarySortButton());
            if (child != null) {
                this.setSortFocus(context, component, child);
            }
            writer.writeText("\n", null);
            writer.startElement("td", component);
            RenderingUtilities.renderComponent(child, context);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
        }
    }

    protected void renderGroupHeader(FacesContext context, TableHeader component, ResponseWriter writer) throws IOException {
        boolean renderTableRowGroupControls;
        if (component == null) {
            this.log("renderGroupHeader", "Cannot render group header, TableHeader is null");
            return;
        }
        TableRowGroup group = component.getTableRowGroupAncestor();
        if (group == null) {
            this.log("renderGroupHeader", "Cannot render group header, TableRowGroup is null");
            return;
        }
        UIComponent facet = group.getFacet("header");
        boolean renderHeader = facet != null && facet.isRendered();
        boolean renderText = group.getHeaderText() != null && !renderHeader;
        boolean bl = renderTableRowGroupControls = !this.isEmptyGroup(component) && (group != null && group.isSelectMultipleToggleButton() || group.isGroupToggleButton());
        if (renderText || renderTableRowGroupControls) {
            Theme theme = this.getTheme();
            writer.writeText("\n", null);
            writer.startElement("span", component);
            writer.writeAttribute("class", theme.getStyleClass("TABLE_GROUP_HEADER_LEFT"), null);
            if (renderTableRowGroupControls) {
                if (group.isSelectMultipleToggleButton()) {
                    writer.writeText("\n", null);
                    RenderingUtilities.renderComponent(component.getSelectMultipleToggleButton(), context);
                }
                if (this.getSelectId(component) != null) {
                    writer.writeText("\n", null);
                    writer.startElement("span", component);
                    writer.writeAttribute("class", theme.getStyleClass("TABLE_GROUP_HEADER_IMAGE"), null);
                    writer.writeText("\n", null);
                    RenderingUtilities.renderComponent(component.getWarningIcon(), context);
                    writer.endElement("span");
                }
                if (group.isGroupToggleButton()) {
                    writer.writeText("\n", null);
                    RenderingUtilities.renderComponent(component.getGroupPanelToggleButton(), context);
                    RenderingUtilities.renderComponent(component.getCollapsedHiddenField(), context);
                }
                if (!renderText) {
                    writer.write("&nbsp;");
                }
            }
            if (renderText) {
                writer.writeText("\n", null);
                writer.startElement("span", component);
                writer.writeAttribute("class", theme.getStyleClass("TABLE_GROUP_HEADER_TEXT"), null);
                writer.writeText(group.getHeaderText(), null);
                writer.endElement("span");
            }
            writer.endElement("span");
        } else {
            this.log("renderGroupHeader", "Group controls not rendered, empty group found");
        }
        if (renderHeader) {
            RenderingUtilities.renderComponent(facet, context);
        }
    }

    protected void renderEnclosingTagStart(FacesContext context, TableHeader component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, TableHeader is null");
            return;
        }
        writer.writeText("\n", null);
        writer.startElement("th", component);
        writer.writeAttribute("id", component.getClientId(context), null);
        String extraHtml = RenderingUtilities.renderStyleClass(context, writer, component, this.getStyleClass(component), component.getExtraHtml());
        if (component.getColSpan() > -1 && (extraHtml == null || extraHtml.indexOf("colspan=") == -1)) {
            writer.writeAttribute("colspan", Integer.toString(component.getColSpan()), null);
        }
        if (component.getRowSpan() > -1 && (extraHtml == null || extraHtml.indexOf("rowspan=") == -1)) {
            writer.writeAttribute("rowspan", Integer.toString(component.getRowSpan()), null);
        }
        if (component.isNoWrap() && (extraHtml == null || extraHtml.indexOf("nowrap=") == -1)) {
            writer.writeAttribute("nowrap", "nowrap", null);
        }
        if (component.getToolTip() != null && (extraHtml == null || extraHtml.indexOf("title=") == -1)) {
            writer.writeAttribute("title", component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes(component, writer, stringAttributes, extraHtml);
    }

    protected void renderEnclosingTagEnd(FacesContext context, TableHeader component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagEnd", "Cannot render enclosing tag, TableHeader is null");
            return;
        }
        writer.endElement("th");
    }

    private String getSelectId(TableHeader component) {
        TableColumn col;
        TableRowGroup group;
        String selectId = null;
        TableRowGroup tableRowGroup = group = component != null ? component.getTableRowGroupAncestor() : null;
        if (group == null) {
            this.log("getSelectId", "Cannot obtain select Id, TableRowGroup is null");
            return selectId;
        }
        Iterator kids = group.getTableColumnChildren();
        while (kids.hasNext() && (!(col = (TableColumn)kids.next()).isRendered() || (selectId = this.getSelectId(col)) == null)) {
        }
        return selectId;
    }

    private String getSelectId(TableColumn component) {
        if (component == null) {
            this.log("getSelectId", "Cannot obtain select Id, TableColumn is null");
            return null;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                String selectId;
                TableColumn col = (TableColumn)kids.next();
                if (!col.isRendered() || (selectId = this.getSelectId(col)) == null) continue;
                return selectId;
            }
        }
        return component.getSelectId();
    }

    private String getStyleClass(TableHeader component) {
        String styleClass = null;
        if (component == null) {
            this.log("getStyleClass", "Cannot obtain style class, TableHeader is null");
            return styleClass;
        }
        if (component.isGroupHeader()) {
            styleClass = "TABLE_GROUP_HEADER";
        } else {
            TableColumn col = component.getTableColumnAncestor();
            if (col != null && col.isSpacerColumn()) {
                styleClass = "TABLE_TD_SPACER";
            } else {
                Iterator kids;
                TableColumn parent = col != null ? col.getTableColumnAncestor() : null;
                Iterator iterator = kids = col != null ? col.getTableColumnChildren() : null;
                styleClass = kids != null && kids.hasNext() ? "TABLE_MULTIPLE_HEADER_ROOT" : (component.getSortLevel() == 1 ? (parent != null ? "TABLE_MULTIPLE_HEADER_SORT" : (component.isSelectHeader() ? "TABLE_HEADER_SELECTCOL_SORT" : "TABLE_HEADER_SORT")) : (parent != null ? "TABLE_MULTIPLE_HEADER" : (component.isSelectHeader() ? "TABLE_HEADER_SELECTCOL" : "TABLE_HEADER")));
            }
        }
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private boolean isEmptyGroup(TableHeader component) {
        boolean result = false;
        if (component == null) {
            this.log("isEmptyGroup", "Cannot determine if group is empty, TableHeader is null");
            return result;
        }
        TableRowGroup group = component.getTableRowGroupAncestor();
        if (group != null) {
            result = group.getRowCount() == 0;
        } else {
            this.log("isEmptyGroup", "Cannot determine if group is empty, TableRowGroup is null");
        }
        return result;
    }

    private void log(String method, String message) {
        Class<?> clazz = this.getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void setSortFocus(FacesContext context, TableHeader tableHeader, UIComponent sortControl) {
        String id = FocusManager.getRequestFocusElementId(context);
        if (id == null) {
            return;
        }
        String prefix = tableHeader.getClientId(context) + ':';
        if (id.equals(prefix + "_addSortButton") || id.equals(prefix + "_primarySortButton") || id.equals(prefix + "_toggleSortButton")) {
            FocusManager.setRequestFocusElementId(context, RenderingUtilities.getFocusElementId(context, sortControl));
        }
    }
}

