/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TableRenderer
extends Renderer {
    private static final String JAVASCRIPT_OBJECT_CLASS = "Table";
    private static final String[] stringAttributes = new String[]{"align", "bgColor", "dir", "frame", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver", "onMouseUp", "rules", "summary"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, table, writer);
        this.renderTitle(context, table, writer);
        this.renderActionsTop(context, table, writer);
        this.renderEmbeddedPanels(context, table, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        Iterator kids = table.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)kids.next();
            RenderingUtilities.renderComponent(group, context);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderActionsBottom(context, table, writer);
        this.renderTableFooter(context, table, writer);
        this.renderEnclosingTagEnd(writer);
        this.renderJavascript(context, table, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderActionsBottom(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderActionsBottom", "Cannot render actions bar, Table is null");
            return;
        }
        UIComponent actions = component.getTableActionsBottom();
        if (actions == null || !actions.isRendered()) {
            this.log("renderActionsBottom", "Actions bar not rendered, nothing to display");
            return;
        }
        writer.writeText("\n", null);
        writer.startElement("tr", component);
        writer.writeAttribute("id", this.getId(component, "_tableActionsBottomBar"), null);
        RenderingUtilities.renderComponent(actions, context);
        writer.endElement("tr");
    }

    protected void renderActionsTop(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderActionsTop", "Cannot render actions bar, Table is null");
            return;
        }
        UIComponent actions = component.getTableActionsTop();
        if (actions == null || !actions.isRendered()) {
            this.log("renderActionsTop", "Actions bar not rendered, nothing to display");
            return;
        }
        writer.writeText("\n", null);
        writer.startElement("tr", component);
        writer.writeAttribute("id", this.getId(component, "_tableActionsTopBar"), null);
        RenderingUtilities.renderComponent(actions, context);
        writer.endElement("tr");
    }

    protected void renderEmbeddedPanels(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEmbeddedPanels", "Cannot render embedded panels, Table is null");
            return;
        }
        UIComponent panels = component.getEmbeddedPanels();
        if (panels == null || !panels.isRendered()) {
            this.log("renderEmbeddedPanels", "Embedded panels not rendered, nothing to display");
            return;
        }
        writer.writeText("\n", null);
        writer.startElement("tr", component);
        writer.writeAttribute("id", this.getId(component, "_embeddedPanelsBar"), null);
        RenderingUtilities.renderComponent(panels, context);
        writer.endElement("tr");
    }

    protected void renderTableFooter(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderTableFooter", "Cannot render table foter, Table is null");
            return;
        }
        UIComponent footer = component.getTableFooter();
        if (footer == null || !footer.isRendered()) {
            this.log("renderTableFooter", "Table footer not rendered, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText("\n", null);
        writer.startElement("tr", component);
        writer.writeAttribute("id", this.getId(component, "_tableFooterBar"), null);
        RenderingUtilities.renderComponent(footer, context);
        writer.endElement("tr");
    }

    protected void renderTitle(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderTitle", "Cannot render title, Table is null");
            return;
        }
        UIComponent facet = component.getFacet("title");
        if (facet != null) {
            this.renderTitleStart(context, component, writer);
            RenderingUtilities.renderComponent(facet, context);
            this.renderTitleEnd(context, writer);
            return;
        }
        if (component.getTitle() == null) {
            this.log("renderTitle", "Title is null, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        String filterText = component.getFilterText();
        filterText = filterText != null && filterText.length() > 0 ? theme.getMessage("table.title.filterApplied", new String[]{filterText}) : "";
        TableRowGroup group = component.getTableRowGroupChild();
        boolean paginated = group != null ? group.isPaginated() : false;
        int totalRows = component.getRowCount();
        boolean emptyTable = totalRows == 0;
        boolean singlePage = totalRows < component.getRows();
        String title = component.getTitle();
        if (component.isAugmentTitle()) {
            if (!emptyTable && !singlePage && paginated) {
                int maxRows = component.getRows();
                int maxFirst = component.getFirst();
                String first = Integer.toString(maxFirst + 1);
                String last = Integer.toString(Math.min(maxFirst + maxRows, totalRows));
                title = component.getItemsText() != null ? theme.getMessage("table.title.paginatedItems", new String[]{component.getTitle(), first, last, Integer.toString(totalRows), component.getItemsText(), filterText}) : theme.getMessage("table.title.paginated", new String[]{component.getTitle(), first, last, Integer.toString(totalRows), filterText});
            } else {
                title = component.getItemsText() != null ? theme.getMessage("table.title.scrollItems", new String[]{component.getTitle(), Integer.toString(totalRows), component.getItemsText(), filterText}) : theme.getMessage("table.title.scroll", new String[]{component.getTitle(), Integer.toString(totalRows), filterText});
            }
        } else {
            this.log("renderTitle", "Title not augmented, itemsText & filterText not displayed");
        }
        this.renderTitleStart(context, component, writer);
        if (component.isHiddenSelectedRows()) {
            writer.startElement("span", component);
            writer.writeAttribute("class", theme.getStyleClass("TABLE_TITLE_TEXT_SPAN"), null);
            writer.writeText(title, null);
            writer.endElement("span");
            writer.startElement("span", component);
            writer.writeAttribute("class", theme.getStyleClass("TABLE_TITLE_MESSAGE_SPAN"), null);
            writer.writeText(theme.getMessage("table.hiddenSelections", new String[]{Integer.toString(component.getHiddenSelectedRowsCount())}), null);
            writer.endElement("span");
        } else {
            writer.writeText(title, null);
        }
        this.renderTitleEnd(context, writer);
    }

    private void renderTitleStart(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        writer.writeText("\n", null);
        writer.startElement("caption", component);
        writer.writeAttribute("id", this.getId(component, "_titleBar"), null);
        writer.writeAttribute("class", this.getTheme().getStyleClass("TABLE_TITLE_TEXT"), null);
        if (component.getExtraTitleHtml() != null) {
            RenderingUtilities.renderExtraHtmlAttributes(writer, component.getExtraTitleHtml());
        }
    }

    private void renderTitleEnd(FacesContext context, ResponseWriter writer) throws IOException {
        writer.endElement("caption");
    }

    protected void renderEnclosingTagStart(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        int first;
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("id", component.getClientId(context), null);
        String style = component.getStyle();
        if (style != null) {
            writer.writeAttribute("style", style, null);
        }
        RenderingUtilities.renderStyleClass(context, writer, component, null);
        writer.writeText("\n", null);
        writer.startElement("div", component);
        String width = component.getWidth();
        if (width != null) {
            if (width.indexOf("%") == -1) {
                width = width + "px";
            }
            writer.writeAttribute("style", "width:" + width, null);
        } else {
            writer.writeAttribute("style", "width:100%", null);
        }
        writer.writeText("\n", null);
        writer.startElement("table", component);
        writer.writeAttribute("id", this.getId(component, "_table"), null);
        String styleClass = theme.getStyleClass("TABLE");
        if (component.isLite()) {
            styleClass = styleClass + " " + theme.getStyleClass("TABLE_LITE");
        }
        writer.writeAttribute("class", styleClass, null);
        writer.writeAttribute("width", "100%", null);
        if (style != null && (first = style.indexOf("height:")) > -1) {
            int last = style.indexOf(";", first);
            if (last > -1) {
                writer.writeAttribute("style", style.substring(first, last + 1), null);
            } else {
                writer.writeAttribute("style", style.substring(first), null);
            }
        }
        this.renderTableAttributes(context, component, writer);
    }

    protected void renderTableAttributes(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        int border = component.getBorder();
        if (border > -1) {
            writer.writeAttribute("border", Integer.toString(border), null);
        } else {
            writer.writeAttribute("border", "0", null);
        }
        String value = component.getCellPadding();
        if (value != null) {
            writer.writeAttribute("cellpadding", value, null);
        } else {
            writer.writeAttribute("cellpadding", "0", null);
        }
        value = component.getCellSpacing();
        if (value != null) {
            writer.writeAttribute("cellspacing", value, null);
        } else {
            writer.writeAttribute("cellspacing", "0", null);
        }
        value = component.getToolTip();
        if (value != null) {
            writer.writeAttribute("title", value, "toolTip");
        }
        RenderingUtilities.writeStringAttributes(component, writer, stringAttributes);
    }

    protected void renderEnclosingTagEnd(ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    private String getId(UIComponent component, String id) {
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        return clientId + ':' + id;
    }

    private String getSelectId(FacesContext context, TableColumn component) {
        TableRowGroup group;
        String selectId = null;
        if (component == null) {
            this.log("getSelectId", "Cannot obtain select Id, TableColumn is null");
            return selectId;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            TableColumn col;
            while (kids.hasNext() && (!(col = (TableColumn)kids.next()).isRendered() || (selectId = this.getSelectId(context, col)) == null)) {
            }
        } else if (component.getSelectId() != null && (group = component.getTableRowGroupAncestor()) != null) {
            String colId = component.getClientId(context);
            String groupId = group.getClientId(context) + ':';
            try {
                selectId = colId.substring(groupId.length(), colId.length()) + ':' + component.getSelectId();
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return selectId;
    }

    private String getSelectSortMenuOptionValue(Table component) {
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                String value;
                TableColumn col = (TableColumn)kids.next();
                if (!col.isRendered() || col.getSelectId() == null || (value = this.getSelectSortMenuOptionValue(col)) == null) continue;
                return value;
            }
        } else {
            this.log("getSelectSortMenuOptionValue", "Cannot obtain select sort menu option value, TableRowGroup is null");
        }
        return null;
    }

    private String getSelectSortMenuOptionValue(TableColumn component) {
        SortCriteria criteria;
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                String value;
                TableColumn col = (TableColumn)kids.next();
                if (!col.isRendered() || col.getSelectId() == null || (value = this.getSelectSortMenuOptionValue(col)) == null) continue;
                return value;
            }
        }
        return (criteria = component.getSortCriteria()) != null ? criteria.getCriteriaKey() : null;
    }

    private JSONArray getSortToolTipJavascript(Table component, boolean descending) {
        String tooltip = descending ? "table.sort.augment.undeterminedDescending" : "table.sort.augment.undeterminedAscending";
        JSONArray json = new JSONArray();
        json.put(this.getTheme().getMessage(tooltip));
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)kids.next();
                if (!col.isRendered()) continue;
                json.put(col.getSortToolTipAugment(descending));
            }
        } else {
            this.log("getSortToolTipJavascript", "Cannot obtain Javascript array of sort tool tips, TableRowGroup is null");
        }
        return json;
    }

    private String getTableColumnFooterStyleClass(TableColumn component, int level) {
        String styleClass = null;
        styleClass = component.isSpacerColumn() ? "TABLE_COL_FOOTER_SPACER" : (level == 1 ? "TABLE_COL_FOOTER_SORT" : "TABLE_COL_FOOTER");
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private void log(String method, String message) {
        Class<?> clazz = this.getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void renderJavascript(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderJavascript", "Cannot render Javascript, Table is null");
            return;
        }
        try {
            StringBuffer buff = new StringBuffer(1024);
            JSONObject json = new JSONObject();
            json.put("id", component.getClientId(context));
            this.appendPanelProperties(context, component, json);
            this.appendFilterProperties(context, component, json);
            this.appendSortPanelProperties(context, component, json);
            this.appendGroupProperties(context, component, json);
            this.appendGroupPanelProperties(context, component, json);
            buff.append(JavaScriptUtilities.getModule("table")).append("\n").append(JavaScriptUtilities.getModuleName("table._init")).append("(").append(JSONUtilities.getString(json)).append(");");
            JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void appendPanelProperties(FacesContext context, Table component, JSONObject json) throws IOException, JSONException {
        if (component == null) {
            this.log("appendPanelProperties", "Cannot obtain properties, Table is null");
            return;
        }
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            this.log("appendPanelProperties", "Cannot obtain panel properties, embedded panels facet is null");
            return;
        }
        Theme theme = this.getTheme();
        String prefix = panels.getClientId(context) + ':';
        JSONArray ary1 = new JSONArray();
        ary1.put(prefix + "_sortPanel").put(prefix + "_preferencesPanel").put(prefix + "_filterPanel");
        json.put("panelIds", ary1);
        UIComponent actions = component.getFacet("_tableActionsTop");
        if (actions == null) {
            this.log("appendPanelProperties", "Cannot obtain properties, facet is null");
            return;
        }
        JSONArray ary2 = new JSONArray();
        ary2.put(component.getSortPanelFocusId() != null ? component.getSortPanelFocusId() : prefix + "_primarySortColumnMenu").put(component.getPreferencesPanelFocusId() != null ? component.getPreferencesPanelFocusId() : JSONObject.NULL).put(component.getFilterPanelFocusId() != null ? component.getFilterPanelFocusId() : JSONObject.NULL);
        json.put("panelFocusIds", ary2);
        prefix = actions.getClientId(context) + ':';
        JSONArray ary3 = new JSONArray();
        ary3.put(prefix + "_sortPanelToggleButton").put(prefix + "_preferencesPanelToggleButton").put(component.getFilterId() != null ? component.getFilterId() : JSONObject.NULL);
        json.put("panelToggleIds", ary3);
        JSONArray ary4 = new JSONArray();
        ary4.put(theme.getImagePath("TABLE_SORT_PANEL_FLIP")).put(theme.getImagePath("TABLE_PREFERENCES_PANEL_FLIP")).put(JSONObject.NULL);
        json.put("panelToggleIconsOpen", ary4);
        JSONArray ary5 = new JSONArray();
        ary5.put(theme.getImagePath("TABLE_SORT_PANEL")).put(theme.getImagePath("TABLE_PREFERENCES_PANEL")).put(JSONObject.NULL);
        json.put("panelToggleIconsClose", ary5);
    }

    private void appendFilterProperties(FacesContext context, Table component, JSONObject json) throws IOException, JSONException {
        if (component == null) {
            this.log("apppendFilterProperties", "Cannot obtain properties, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        json.put("basicFilterStyleClass", theme.getStyleClass("MENU_JUMP")).put("customFilterStyleClass", theme.getStyleClass("TABLE_CUSTOM_FILTER_MENU")).put("customFilterOptionValue", "_customFilter").put("customFilterAppliedOptionValue", "_customFilterApplied");
    }

    private void appendGroupProperties(FacesContext context, Table component, JSONObject json) throws IOException, JSONException {
        if (component == null) {
            this.log("appendGroupProperties", "Cannot obtain properties, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        json.put("selectRowStyleClass", theme.getStyleClass("TABLE_SELECT_ROW"));
        JSONArray ary1 = new JSONArray();
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableColumn col;
            TableRowGroup group = (TableRowGroup)kids.next();
            Object selectId = null;
            Iterator grandkids = group.getTableColumnChildren();
            while (grandkids.hasNext() && (!(col = (TableColumn)grandkids.next()).isRendered() || (selectId = this.getSelectId(context, col)) == null)) {
            }
            ary1.put(selectId != null ? selectId : JSONObject.NULL);
        }
        json.put("selectIds", ary1);
        JSONArray ary2 = new JSONArray();
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)kids.next();
            ary2.put(group.getClientId(context));
        }
        json.put("groupIds", ary2);
        JSONArray ary3 = new JSONArray();
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)kids.next();
            RowKey[] rowKeys = group.getRenderedRowKeys();
            JSONArray tmp = new JSONArray();
            ary3.put(tmp);
            if (rowKeys != null) {
                for (int i = 0; i < rowKeys.length; ++i) {
                    tmp.put(rowKeys[i].getRowId());
                }
                continue;
            }
            tmp.put(JSONObject.NULL);
        }
        json.put("rowIds", ary3);
        JSONArray ary4 = new JSONArray();
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)kids.next();
            if (component.isHiddenSelectedRows()) {
                ary4.put(group.getHiddenSelectedRowsCount());
                continue;
            }
            ary4.put(0);
        }
        json.put("hiddenSelectedRowCounts", ary4).put("hiddenSelectionsMsg", theme.getMessage("table.confirm.hiddenSelections")).put("totalSelectionsMsg", theme.getMessage("table.confirm.totalSelections")).put("deleteSelectionsMsg", theme.getMessage("table.confirm.deleteSelections"));
    }

    private void appendGroupPanelProperties(FacesContext context, Table component, JSONObject json) throws IOException, JSONException {
        if (component == null) {
            this.log("appendGroupPanelProperties", "Cannot obtain properties, Table is null");
            return;
        }
        String prefix = "_groupHeader:";
        Theme theme = this.getTheme();
        json.put("columnFooterId", "_columnFooterBar").put("columnHeaderId", "_columnHeaderBar").put("tableColumnFooterId", "_tableColumnFooterBar").put("groupFooterId", "_groupFooterBar").put("groupPanelToggleButtonId", prefix + "_groupPanelToggleButton").put("groupPanelToggleButtonToolTipOpen", theme.getMessage("table.group.collapse")).put("groupPanelToggleButtonToolTipClose", theme.getMessage("table.group.expand")).put("groupPanelToggleIconOpen", theme.getImagePath("TABLE_GROUP_PANEL_FLIP")).put("groupPanelToggleIconClose", theme.getImagePath("TABLE_GROUP_PANEL")).put("warningIconId", prefix + "_warningIcon").put("warningIconOpen", theme.getImagePath("DOT")).put("warningIconClose", theme.getImagePath("ALERT_WARNING_SMALL")).put("warningIconToolTipOpen", JSONObject.NULL).put("warningIconToolTipClose", theme.getMessage("table.group.warning")).put("collapsedHiddenFieldId", prefix + "_collapsedHiddenField").put("selectMultipleToggleButtonId", prefix + "_selectMultipleToggleButton").put("selectMultipleToggleButtonToolTip", theme.getMessage("table.group.selectMultiple")).put("selectMultipleToggleButtonToolTipSelected", theme.getMessage("table.group.deselectMultiple"));
    }

    private void appendSortPanelProperties(FacesContext context, Table component, JSONObject json) throws IOException, JSONException {
        if (component == null) {
            this.log("appendSortPanelProperties", "Cannot obtain properties, Table is null");
            return;
        }
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            this.log("appendSortPanelProperties", "Cannot obtain properties, Embedded panels facet is null");
            return;
        }
        Theme theme = this.getTheme();
        String prefix = panels.getClientId(context) + ':';
        JSONArray ary1 = new JSONArray();
        ary1.put(prefix + "_primarySortColumnMenu").put(prefix + "_secondarySortColumnMenu").put(prefix + "_tertiarySortColumnMenu");
        json.put("sortColumnMenuIds", ary1);
        JSONArray ary2 = new JSONArray();
        ary2.put(prefix + "_primarySortOrderMenu").put(prefix + "_secondarySortOrderMenu").put(prefix + "_tertiarySortOrderMenu");
        json.put("sortOrderMenuIds", ary2);
        JSONArray ary3 = new JSONArray();
        ary3.put(theme.getMessage("table.panel.primarySortOrder")).put(theme.getMessage("table.panel.secondarySortOrder")).put(theme.getMessage("table.panel.tertiarySortOrder"));
        json.put("sortOrderToolTips", ary3);
        String value = this.getSelectSortMenuOptionValue(component);
        TableRowGroup group = component.getTableRowGroupChild();
        json.put("sortOrderToolTipsAscending", this.getSortToolTipJavascript(component, false)).put("sortOrderToolTipsDescending", this.getSortToolTipJavascript(component, true)).put("duplicateSelectionMsg", theme.getMessage("table.panel.duplicateSelectionError")).put("missingSelectionMsg", theme.getMessage("table.panel.missingSelectionError")).put("selectSortMenuOptionValue", value != null ? value : null).put("hiddenSelectedRows", component.isHiddenSelectedRows()).put("paginated", group != null ? group.isPaginated() : false);
    }
}

