/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.DndContainer;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DndContainerRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"horizontalMarker", "copyOnly", "onNodeCreateFunc", "onDropFunc", "style", "styleClass", "visible"};
    private static final String[] intAttributes = new String[]{"tabIndex"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof DndContainer)) {
            throw new IllegalArgumentException("DndContainerRenderer can only render DndContainer components.");
        }
        DndContainer container = (DndContainer)component;
        JSONObject json = new JSONObject();
        this.tokenizeToArray(json, "dropTypes", container.getDropTypes());
        this.tokenizeToArray(json, "dragTypes", container.getDragTypes());
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        this.setContents(context, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.dndContainer");
    }

    protected void setContents(FacesContext context, UIComponent component, JSONObject json) throws IOException, JSONException {
        Iterator<UIComponent> kids = component.getChildren().iterator();
        if (!kids.hasNext()) {
            return;
        }
        JSONArray jArray = new JSONArray();
        json.put("contents", jArray);
        JSONArray jArrayDragData = new JSONArray();
        json.put("contentsDragData", jArrayDragData);
        while (kids.hasNext()) {
            UIComponent child = kids.next();
            if (!child.isRendered()) continue;
            jArray.put(WidgetUtilities.renderComponent(context, child));
            String dragData = child.getClientId(context);
            jArrayDragData.put(dragData);
        }
    }

    protected JSONObject tokenizeToArray(JSONObject json, String name, String content) throws JSONException {
        if (content == null) {
            return json;
        }
        JSONArray jArray = new JSONArray();
        json.put(name, jArray);
        StringTokenizer st = new StringTokenizer(content, ", ");
        while (st.hasMoreTokens()) {
            jArray.put(st.nextToken());
        }
        return json;
    }
}

