/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThemeLogger {
    protected static String LOGGER_NAME = "com.sun.webui.theme";
    protected static String LOGGER_KEY = "WEBUITHEME001";
    protected static String LOGGER_MSG_SEPARATOR = ": ";
    protected static Level DEFAULT_LEVEL = Level.FINEST;
    protected static String BUNDLE = "com.sun.webui.theme.LogMessages";
    protected static String noBundleLogMessage;
    private static String msgPrefix;

    public static void log(Level level, String msg, Object[] args, Throwable throwable) {
        Logger logger = Logger.getLogger(LOGGER_NAME);
        if (msg == null || msg.length() == 0) {
            if (throwable != null) {
                logger.log(level == null ? DEFAULT_LEVEL : level, msgPrefix, throwable);
            }
            return;
        }
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(BUNDLE);
        }
        catch (MissingResourceException mre) {
            logger.log(Level.WARNING, noBundleLogMessage, mre);
        }
        if (bundle != null) {
            try {
                String tmpMsg = bundle.getString(msg);
                if (tmpMsg != null && tmpMsg.length() != 0) {
                    msg = tmpMsg;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (args != null) {
            try {
                msg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (level == null) {
            level = DEFAULT_LEVEL;
        }
        if (throwable != null) {
            logger.log(level, msgPrefix + msg, throwable);
        } else {
            logger.log(level, msgPrefix + msg);
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append(LOGGER_KEY).append(LOGGER_MSG_SEPARATOR);
        msgPrefix = sb.toString();
        sb.setLength(0);
        sb.append(msgPrefix).append("ResourceBundle.getBundle(").append(BUNDLE).append(") failed.");
        noBundleLogMessage = sb.toString();
    }
}

