/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Pipeline;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardDefaultContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.modeler.Registry;
import org.glassfish.web.valve.GlassFishValve;

public class StandardHost
extends ContainerBase
implements Deployer,
Host {
    private static Logger log = Logger.getLogger(StandardHost.class.getName());
    protected String[] aliases = new String[0];
    private String appBase = ".";
    private boolean autoDeploy = true;
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private Deployer deployer = null;
    private boolean deployOnStartup = true;
    private boolean deployXML = true;
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private boolean liveDeploy = true;
    private boolean unpackWARs = true;
    private String workDir = null;
    private DefaultContext defaultContext;
    private boolean xmlValidation = false;
    private boolean xmlNamespaceAware = false;
    private HashMap<Integer, ErrorPage> statusPages = new HashMap();
    private int[] ports = new int[0];
    private boolean securePagesWithPragma = true;
    private SingleSignOn sso;
    static String STANDARD_HOST_DEPLOYER = "org.apache.catalina.core.StandardHostDeployer";

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public void setPipeline(Pipeline pl) {
        pl.setBasic(new StandardHostValve());
        this.pipeline = pl;
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) {
        boolean oldAutoDeploy = this.autoDeploy;
        this.autoDeploy = autoDeploy;
        this.support.firePropertyChange("autoDeploy", oldAutoDeploy, this.autoDeploy);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    public boolean getDeployOnStartup() {
        return this.deployOnStartup;
    }

    public void setDeployOnStartup(boolean deployOnStartup) {
        boolean oldDeployOnStartup = this.deployOnStartup;
        this.deployOnStartup = deployOnStartup;
        this.support.firePropertyChange("deployOnStartup", oldDeployOnStartup, this.deployOnStartup);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean getLiveDeploy() {
        return this.autoDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        this.setAutoDeploy(liveDeploy);
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setPorts(int[] ports) {
        int[] oldPorts = this.ports;
        this.ports = (int[])ports.clone();
        this.support.firePropertyChange("ports", oldPorts, this.ports);
    }

    public int[] getPorts() {
        return (int[])this.ports.clone();
    }

    public void installDefaultContext(Context context) {
        if (this.defaultContext != null && this.defaultContext instanceof StandardDefaultContext) {
            ((StandardDefaultContext)this.defaultContext).installDefaultContext(context);
        }
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void addAlias(String alias) {
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(alias)) continue;
            return;
        }
        String[] newAliases = new String[this.aliases.length + 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            newAliases[i] = this.aliases[i];
        }
        newAliases[this.aliases.length] = alias;
        this.aliases = newAliases;
        this.fireContainerEvent("addAlias", alias);
    }

    public void addChild(Container child) {
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        super.addChild(child);
    }

    public Container findChild(String contextRoot) {
        return super.findChild(RequestUtil.URLDecode(contextRoot));
    }

    public String[] findAliases() {
        return this.aliases;
    }

    public int[] findPorts() {
        return this.getPorts();
    }

    public Host findMappingObject() {
        return (Host)this.getMappingObject();
    }

    public String getInfo() {
        return info;
    }

    public Context map(String uri) {
        int slash;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Mapping request URI '" + uri + "'");
        }
        if (uri == null) {
            return null;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Trying the longest context path prefix");
        }
        Context context = null;
        String mapuri = uri;
        while ((context = (Context)this.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
            mapuri = mapuri.substring(0, slash);
        }
        if (context == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            log.severe(sm.getString("standardHost.mappingError", uri));
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Mapped to context '" + context.getPath() + "'");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String alias) {
        String[] stringArray = this.aliases;
        synchronized (this.aliases) {
            int n = -1;
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(alias)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.aliases.length - 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                if (i == n) continue;
                results[j++] = this.aliases[i];
            }
            this.aliases = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeAlias", alias);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorPage(ErrorPage errorPage) {
        if (errorPage == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.errorPage.required"));
        }
        HashMap<Integer, ErrorPage> hashMap = this.statusPages;
        synchronized (hashMap) {
            this.statusPages.put(errorPage.getErrorCode(), errorPage);
        }
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    public ErrorPage findErrorPage(int errorCode) {
        return this.statusPages.get(errorCode);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void start() throws LifecycleException {
        block12: {
            if (this.started) {
                return;
            }
            if (!this.initialized) {
                this.init();
            }
            if (this.realm == null) {
                ObjectName realmName = null;
                try {
                    realmName = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                    if (this.mserver.isRegistered(realmName)) {
                        this.mserver.invoke(realmName, "setContext", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
                    }
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.FINE)) break block12;
                    log.fine("No realm for this host " + realmName);
                }
            }
        }
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                GlassFishValve valve = (GlassFishValve)Class.forName(this.errorReportValveClass).newInstance();
                ((StandardHostValve)this.pipeline.getBasic()).setErrorReportValve(valve);
            }
            catch (Throwable t) {
                log.severe(sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass));
            }
        }
        if (log.isLoggable(Level.FINE)) {
            if (this.xmlValidation) {
                log.fine(sm.getString("standardHost.validationEnabled"));
            } else {
                log.fine(sm.getString("standardHost.validationDisabled"));
            }
        }
        super.start();
    }

    public void backgroundProcess() {
        this.lifecycle.fireLifecycleEvent("check", null);
    }

    public void install(String contextPath, URL war) throws IOException {
        this.getDeployer().install(contextPath, war);
    }

    public synchronized void install(URL config, URL war) throws IOException {
        this.getDeployer().install(config, war);
    }

    public Context findDeployedApp(String contextPath) {
        return this.getDeployer().findDeployedApp(contextPath);
    }

    public String[] findDeployedApps() {
        return this.getDeployer().findDeployedApps();
    }

    public void remove(String contextPath) throws IOException {
        this.getDeployer().remove(contextPath);
    }

    public void remove(String contextPath, boolean undeploy) throws IOException {
        this.getDeployer().remove(contextPath, undeploy);
    }

    public void start(String contextPath) throws IOException {
        this.getDeployer().start(contextPath);
    }

    public void stop(String contextPath) throws IOException {
        this.getDeployer().stop(contextPath);
    }

    public boolean isSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        boolean oldSecurePagesWithPragma = this.securePagesWithPragma;
        this.securePagesWithPragma = securePagesWithPragma;
        this.support.firePropertyChange("securePagesWithPragma", (Object)oldSecurePagesWithPragma, (Object)this.securePagesWithPragma);
    }

    public void addValve(GlassFishValve valve) {
        super.addValve(valve);
        if (valve instanceof SingleSignOn) {
            this.sso = (SingleSignOn)valve;
        }
    }

    public void removeValve(GlassFishValve valve) {
        super.removeValve(valve);
        if (valve instanceof SingleSignOn) {
            this.sso = null;
        }
    }

    public SingleSignOn getSingleSignOn() {
        return this.sso;
    }

    public Deployer getDeployer() {
        if (this.deployer != null) {
            return this.deployer;
        }
        log.info("Create Host deployer for direct deployment ( non-jmx ) ");
        try {
            Class<?> c = Class.forName(STANDARD_HOST_DEPLOYER);
            this.deployer = (Deployer)c.newInstance();
            Method m = c.getMethod("setHost", Host.class);
            m.invoke((Object)this.deployer, this);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error creating deployer ", t);
        }
        return this.deployer;
    }

    public void setDeployer(Deployer d) {
        this.deployer = d;
    }

    public String[] getValveNames() throws Exception {
        GlassFishValve[] valves = this.getValves();
        String[] mbeanNames = new String[valves.length];
        for (int i = 0; i < valves.length; ++i) {
            if (valves[i] == null || ((ValveBase)valves[i]).getObjectName() == null) continue;
            mbeanNames[i] = ((ValveBase)valves[i]).getObjectName().toString();
        }
        return mbeanNames;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        if (this.getParent() == null) {
            try {
                ObjectName serviceName = new ObjectName(this.domain + ":type=Engine");
                if (this.mserver.isRegistered(serviceName)) {
                    log.fine("Registering with the Engine");
                    this.mserver.invoke(serviceName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.oname == null) {
            try {
                StandardEngine engine = (StandardEngine)this.parent;
                this.domain = engine.getName();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Registering host " + this.getName() + " with domain " + this.domain);
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.log(Level.INFO, "Error registering ", t);
            }
        }
        this.initialized = true;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        ObjectName res = super.preRegister(server, oname);
        String name = oname.getKeyProperty("host");
        if (name != null) {
            this.setName(name);
        }
        return res;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Create ObjectName " + domain + " " + parent);
        }
        return new ObjectName(domain + ":type=Host,host=" + this.getName());
    }
}

