/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

public final class Cookies {
    private static Logger log = Logger.getLogger(Cookies.class.getName());
    public static final int INITIAL_SIZE = 4;
    ServerCookie[] scookies = new ServerCookie[4];
    int cookieCount = 0;
    boolean unprocessed = true;
    MimeHeaders headers;
    static final int dbg = 0;

    public Cookies(MimeHeaders headers) {
        this.headers = headers;
    }

    public Cookies() {
    }

    public void setHeaders(MimeHeaders headers) {
        this.recycle();
        this.headers = headers;
    }

    public void recycle() {
        for (int i = 0; i < this.cookieCount; ++i) {
            if (this.scookies[i] == null) continue;
            this.scookies[i].recycle();
        }
        this.cookieCount = 0;
        this.unprocessed = true;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== Cookies ===");
        int count = this.getCookieCount();
        for (int i = 0; i < count; ++i) {
            pw.println(this.getCookie(i).toString());
        }
        return sw.toString();
    }

    public ServerCookie getCookie(int idx) {
        if (this.unprocessed) {
            this.getCookieCount();
        }
        return this.scookies[idx];
    }

    public int getCookieCount() {
        if (this.unprocessed) {
            this.processCookies(this.headers);
        }
        return this.cookieCount;
    }

    public ServerCookie addCookie() {
        ServerCookie c;
        if (this.cookieCount >= this.scookies.length) {
            ServerCookie[] scookiesTmp = new ServerCookie[2 * this.cookieCount];
            System.arraycopy(this.scookies, 0, scookiesTmp, 0, this.cookieCount);
            this.scookies = scookiesTmp;
        }
        if ((c = this.scookies[this.cookieCount]) == null) {
            this.scookies[this.cookieCount] = c = new ServerCookie();
        }
        ++this.cookieCount;
        return c;
    }

    public void processCookies(MimeHeaders headers) {
        this.unprocessed = false;
        if (headers == null) {
            return;
        }
        int pos = 0;
        while (pos >= 0 && (pos = headers.findHeader("Cookie", pos)) >= 0) {
            MessageBytes cookieValue = headers.getValue(pos);
            if (cookieValue == null || cookieValue.isNull()) {
                ++pos;
                continue;
            }
            if (cookieValue.getType() == 2) {
                ByteChunk bc = cookieValue.getByteChunk();
                this.processCookieHeader(bc.getBytes(), bc.getOffset(), bc.getLength());
            } else {
                this.processCookieHeader(cookieValue.toString());
            }
            ++pos;
        }
    }

    public void processCookieHeader(byte[] bytes, int off, int len) {
        this.unprocessed = false;
        if (len <= 0 || bytes == null) {
            return;
        }
        int end = off + len;
        int pos = off;
        int version = 0;
        ServerCookie sc = null;
        while (pos < end) {
            int startValue;
            int endName;
            if ((pos = Cookies.skipSpaces(bytes, pos, end)) >= end) {
                return;
            }
            int startName = pos;
            boolean isSpecial = false;
            if (bytes[pos] == 36) {
                ++pos;
                isSpecial = true;
            }
            if ((pos = Cookies.skipSpaces(bytes, endName = (pos = Cookies.findDelim1(bytes, startName, end)), end)) >= end) {
                if (!isSpecial) {
                    sc = this.addCookie();
                    sc.getName().setBytes(bytes, startName, endName - startName);
                    sc.getValue().setString("");
                    sc.setVersion(version);
                }
                return;
            }
            byte cc = bytes[pos];
            if (cc == 59 || cc == 44 || ++pos >= end) {
                if (isSpecial || startName == endName) continue;
                sc = this.addCookie();
                sc.getName().setBytes(bytes, startName, endName - startName);
                sc.getValue().setString("");
                sc.setVersion(version);
                continue;
            }
            int endValue = startValue = Cookies.skipSpaces(bytes, pos, end);
            cc = bytes[pos];
            if (cc == 39 || cc == 34) {
                endValue = Cookies.indexOf(bytes, ++startValue, end, cc);
                pos = endValue + 1;
            } else {
                endValue = Cookies.findDelim2(bytes, startValue, end);
                pos = endValue + 1;
            }
            if (!isSpecial) {
                sc = this.addCookie();
                sc.getName().setBytes(bytes, startName, endName - startName);
                sc.getValue().setBytes(bytes, startValue, endValue - startValue);
                sc.setVersion(version);
                continue;
            }
            if (Cookies.equals("$Version", bytes, startName, endName)) {
                if (bytes[startValue] != 49 || endValue != startValue + 1) continue;
                version = 1;
                continue;
            }
            if (sc == null) continue;
            if (Cookies.equals("$Path", bytes, startName, endName)) {
                sc.getPath().setBytes(bytes, startValue, endValue - startValue);
            }
            if (Cookies.equals("$Domain", bytes, startName, endName)) {
                sc.getDomain().setBytes(bytes, startValue, endValue - startValue);
            }
            if (!Cookies.equals("$Port", bytes, startName, endName)) continue;
        }
    }

    public static int skipSpaces(byte[] bytes, int off, int end) {
        while (off < end) {
            byte b = bytes[off];
            if (b != 32) {
                return off;
            }
            ++off;
        }
        return off;
    }

    public static int findDelim1(byte[] bytes, int off, int end) {
        while (off < end) {
            byte b = bytes[off];
            if (b == 32 || b == 61 || b == 59 || b == 44) {
                return off;
            }
            ++off;
        }
        return off;
    }

    public static int findDelim2(byte[] bytes, int off, int end) {
        while (off < end) {
            byte b = bytes[off];
            if (b == 59 || b == 44) {
                return off;
            }
            ++off;
        }
        return off;
    }

    public static int indexOf(byte[] bytes, int off, int end, byte qq) {
        while (off < end) {
            byte b = bytes[off];
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return off;
    }

    public static int indexOf(byte[] bytes, int off, int end, char qq) {
        while (off < end) {
            byte b = bytes[off];
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return off;
    }

    public static boolean equals(String s, byte[] b, int start, int end) {
        int blen = end - start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void processCookieHeader(String cookieString) {
        StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1) continue;
            String name = token.substring(0, i).trim();
            String value = token.substring(i + 1, token.length()).trim();
            value = Cookies.stripQuote(value);
            ServerCookie cookie = this.addCookie();
            cookie.getName().setString(name);
            cookie.getValue().setString(value);
        }
    }

    private static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public void log(String s) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Cookies: " + s);
        }
    }
}

