/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.buf.TimeStamp;
import org.apache.tomcat.util.threads.Reaper;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public final class Expirer
implements ThreadPoolRunnable {
    private static Logger log = Logger.getLogger(Expirer.class.getName());
    private int checkInterval = 60;
    private Reaper reaper;
    ExpireCallback expireCallback;
    static final int INITIAL_SIZE = 8;
    TimeStamp[] managedObjs = new TimeStamp[8];
    TimeStamp[] checkedObjs = new TimeStamp[8];
    int managedLen = this.managedObjs.length;
    int managedCount = 0;
    private static final int dL = 0;

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setExpireCallback(ExpireCallback cb) {
        this.expireCallback = cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedObject(TimeStamp ts) {
        TimeStamp[] timeStampArray = this.managedObjs;
        synchronized (this.managedObjs) {
            if (this.managedCount >= this.managedLen) {
                TimeStamp[] newA = new TimeStamp[2 * this.managedLen];
                System.arraycopy(this.managedObjs, 0, newA, 0, this.managedLen);
                this.managedObjs = newA;
                this.managedLen = 2 * this.managedLen;
            }
            this.managedObjs[this.managedCount] = ts;
            ++this.managedCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedObject(TimeStamp ts) {
        for (int i = 0; i < this.managedCount; ++i) {
            if (ts != this.managedObjs[i]) continue;
            TimeStamp[] timeStampArray = this.managedObjs;
            synchronized (this.managedObjs) {
                this.managedObjs[i] = this.managedObjs[this.managedCount - 1];
                --this.managedCount;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    public void start() {
        if (this.reaper == null) {
            this.reaper = new Reaper("Expirer");
            this.reaper.addCallback(this, this.checkInterval * 1000);
        }
        this.reaper.startReaper();
    }

    public void stop() {
        this.reaper.stopReaper();
    }

    public Object[] getInitData() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIt(Object[] td) {
        long timeNow = System.currentTimeMillis();
        TimeStamp[] timeStampArray = this.managedObjs;
        synchronized (this.managedObjs) {
            int checkedCount = this.managedCount;
            if (this.checkedObjs.length < checkedCount) {
                this.checkedObjs = new TimeStamp[this.managedLen];
            }
            System.arraycopy(this.managedObjs, 0, this.checkedObjs, 0, checkedCount);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            for (int i = 0; i < checkedCount; ++i) {
                long timeIdle;
                long maxInactiveInterval;
                TimeStamp ts = this.checkedObjs[i];
                this.checkedObjs[i] = null;
                if (ts == null || !ts.isValid() || (maxInactiveInterval = ts.getMaxInactiveInterval()) < 0L || (timeIdle = timeNow - ts.getLastAccessedTime()) < maxInactiveInterval || this.expireCallback == null) continue;
                this.expireCallback.expired(ts);
            }
            return;
        }
    }

    private void debug(String s) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Expirer: " + s);
        }
    }

    public static interface ExpireCallback {
        public void expired(TimeStamp var1);
    }
}

