/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class Reaper
extends Thread {
    private static Logger log = Logger.getLogger(Reaper.class.getName());
    private boolean daemon = false;
    private long interval = 60000L;
    ThreadPoolRunnable[] cbacks = new ThreadPoolRunnable[30];
    Object[][] tdata = new Object[30][];
    int count = 0;
    Object lock = new Object();
    private boolean running = true;

    public Reaper() {
        if (this.daemon) {
            this.setDaemon(true);
        }
        this.setName("TomcatReaper");
    }

    public Reaper(String name) {
        if (this.daemon) {
            this.setDaemon(true);
        }
        this.setName(name);
    }

    public void setDefaultInterval(long t) {
        this.interval = t;
    }

    public long getDefaultIntervale() {
        return this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCallback(ThreadPoolRunnable c, int interval) {
        Object object = this.lock;
        synchronized (object) {
            this.cbacks[this.count] = c;
            ++this.count;
            return this.count - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(int idx) {
        Object object = this.lock;
        synchronized (object) {
            --this.count;
            this.cbacks[idx] = this.cbacks[this.count];
            this.cbacks[this.count] = null;
        }
    }

    public void startReaper() {
        this.running = true;
        this.start();
    }

    public synchronized void stopReaper() {
        this.running = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stop reaper ");
        }
        this.interrupt();
    }

    public void run() {
        block2: while (this.running && this.running) {
            try {
                Reaper.sleep(this.interval);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.running) break;
            for (int i = 0; i < this.count; ++i) {
                ThreadPoolRunnable callB = this.cbacks[i];
                if (callB != null) {
                    callB.runIt(this.tdata[i]);
                }
                if (!this.running) continue block2;
            }
        }
    }
}

