/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.adapters.aq;

import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import oracle.AQ.AQDequeueOption;
import oracle.AQ.AQEnqueueOption;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.internal.eis.adapters.aq.AQDequeueInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQEnqueueInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQInteractionSpec;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.w3c.dom.Element;

public class AQPlatform
extends EISPlatform {
    public static String QUEUE = "queue";
    public static String SCHEMA = "schema";
    public static String QUEUE_OPERATION = "operation";
    public static String ENQUEUE = "enqueue";
    public static String DEQUEUE = "dequeue";
    public static String ENQUEUE_OPTIONS = "enqueue-options";
    public static String DEQUEUE_OPTIONS = "dequeue-options";

    public AQPlatform() {
        this.setShouldConvertDataToStrings(true);
        this.setIsMappedRecordSupported(false);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(true);
    }

    public InteractionSpec buildInteractionSpec(EISInteraction interaction) {
        InteractionSpec spec = interaction.getInteractionSpec();
        if (spec == null) {
            AQInteractionSpec aqSpec;
            if (interaction.getProperty(QUEUE_OPERATION) == null) {
                throw EISException.resourceException(new ResourceException(QUEUE_OPERATION + " properties must be set."), interaction, null, null);
            }
            if (interaction.getProperty(QUEUE_OPERATION).equals(ENQUEUE)) {
                aqSpec = new AQEnqueueInteractionSpec();
                AQEnqueueOption options = (AQEnqueueOption)interaction.getProperty(ENQUEUE_OPTIONS);
                if (options != null) {
                    ((AQEnqueueInteractionSpec)aqSpec).setOptions(options);
                }
            } else {
                aqSpec = new AQDequeueInteractionSpec();
                AQDequeueOption options = (AQDequeueOption)interaction.getProperty(DEQUEUE_OPTIONS);
                if (options != null) {
                    ((AQDequeueInteractionSpec)aqSpec).setOptions(options);
                }
            }
            aqSpec.setQueue((String)interaction.getProperty(QUEUE));
            aqSpec.setSchema((String)interaction.getProperty(SCHEMA));
            spec = aqSpec;
        }
        return spec;
    }

    public Record createDOMRecord(String recordName, EISAccessor accessor) {
        try {
            return accessor.getRecordFactory().createIndexedRecord(recordName);
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public void setDOMInRecord(Element dom, Record record, EISInteraction call, EISAccessor accessor) {
        IndexedRecord indexedRecord = (IndexedRecord)record;
        indexedRecord.add(new DOMRecord(dom).transformToXML());
    }

    public AbstractRecord createDatabaseRowFromDOMRecord(Record record, EISInteraction call, EISAccessor accessor) {
        EISDOMRecord domRecord = new EISDOMRecord();
        IndexedRecord indexedRecord = (IndexedRecord)record;
        if (indexedRecord.size() == 0) {
            return null;
        }
        byte[] bytes = (byte[])indexedRecord.get(0);
        domRecord.transformFromXML(new String(bytes));
        return domRecord;
    }
}

