/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class FunctionExpression
extends BaseExpression {
    protected Vector children = NonSynchronizedVector.newInstance(2);
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Class resultType = null;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FunctionExpression expression = (FunctionExpression)object;
        if (!(this.getOperator() == expression.getOperator() || this.getOperator() != null && this.getOperator().equals(expression.getOperator()))) {
            return false;
        }
        Vector children = this.getChildren();
        Vector otherChildren = expression.getChildren();
        int size = children.size();
        if (size != otherChildren.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            if (children.get(index).equals(otherChildren.get(index))) continue;
            return false;
        }
        return true;
    }

    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getOperator() != null) {
            hashCode += this.getOperator().hashCode();
        }
        Vector children = this.getChildren();
        int size = children.size();
        for (int index = 0; index < size; ++index) {
            hashCode += children.get(index).hashCode();
        }
        return hashCode;
    }

    public void addChild(Expression child) {
        this.getChildren().addElement(child);
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        return this.getBaseExpression().aliasForTable(table);
    }

    public Expression asOf(AsOfClause clause) {
        final AsOfClause finalClause = clause;
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                if (each.isDataExpression()) {
                    each.asOf(finalClause);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        iterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression base, Object singleArgument, ExpressionOperator operator) {
        this.baseExpression = base;
        this.addChild(base);
        Expression arg = Expression.from(singleArgument, base);
        this.addChild(arg);
        this.setOperator(operator);
        return this;
    }

    public Expression createWithBaseLast(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        this.baseExpression = base;
        Expression arg = Expression.from(singleArgument, base);
        this.addChild(arg);
        this.addChild(base);
        this.setOperator(anOperator);
        return this;
    }

    public Expression create(Expression base, Vector arguments, ExpressionOperator operator) {
        this.baseExpression = base;
        this.addChild(base);
        Enumeration e = arguments.elements();
        while (e.hasMoreElements()) {
            Expression arg = Expression.from(e.nextElement(), base);
            this.addChild(arg);
        }
        this.setOperator(operator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Function";
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.getOperator().getSelector() == 3) {
            return !this.getBaseExpression().doesConform(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        }
        if (this.getOperator().getSelector() == 15 || this.getOperator().getSelector() == 16 || this.getOperator().getSelector() == 13 || this.getOperator().getSelector() == 14) {
            Object leftValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            Vector rightValue = new Vector(this.getChildren().size());
            for (int index = 1; index < this.getChildren().size(); ++index) {
                Object valueFromRight = this.getChildren().elementAt(index) instanceof Expression ? ((Expression)this.getChildren().elementAt(index)).valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered) : this.getChildren().elementAt(index);
                if (valueFromRight instanceof Vector) {
                    rightValue = (Vector)valueFromRight;
                    continue;
                }
                rightValue.addElement(valueFromRight);
            }
            if (leftValue instanceof Vector) {
                Enumeration leftEnum = ((Vector)leftValue).elements();
                while (leftEnum.hasMoreElements()) {
                    Object tempLeft = leftEnum.nextElement();
                    if (!this.getOperator().doesRelationConform(tempLeft, rightValue)) continue;
                    return true;
                }
                return false;
            }
            return this.getOperator().doesRelationConform(leftValue, rightValue);
        }
        if (this.getOperator().getSelector() == 17 || this.getOperator().getSelector() == 18) {
            Object leftValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            if (leftValue instanceof Vector) {
                Enumeration leftEnum = ((Vector)leftValue).elements();
                while (leftEnum.hasMoreElements()) {
                    Object tempLeft = leftEnum.nextElement();
                    if (!this.getOperator().doesRelationConform(tempLeft, null)) continue;
                    return true;
                }
                return false;
            }
            return this.getOperator().doesRelationConform(leftValue, null);
        }
        throw QueryException.cannotConformExpression();
    }

    public Vector getChildren() {
        return this.children;
    }

    public Vector getFields() {
        return this.getBaseExpression().getFields();
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform platform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(platform);
        }
        return this.platformOperator;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public boolean hasResultType() {
        return this.resultType != null;
    }

    public void initializePlatformOperator(DatabasePlatform platform) {
        if (this.getOperator().isComplete()) {
            this.platformOperator = this.getOperator();
            return;
        }
        this.platformOperator = platform.getOperator(this.getOperator().getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.getOperator().toString());
        }
    }

    public boolean isFunctionExpression() {
        return true;
    }

    protected boolean isObjectComparison() {
        if (this.getChildren().size() != 1) {
            return false;
        }
        int selector = this.getOperator().getSelector();
        if (selector != 17 && selector != 18) {
            return false;
        }
        Expression base = this.getBaseExpression();
        return base.isObjectExpression() && !((ObjectExpression)base).isAttribute();
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        Enumeration childrenEnum = this.getChildren().elements();
        while (childrenEnum.hasMoreElements()) {
            Expression child = (Expression)childrenEnum.nextElement();
            child.iterateOn(iterator);
        }
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        if (this.getChildren().isEmpty()) {
            return this;
        }
        if (!this.isObjectComparison()) {
            for (int index = 0; index < this.getChildren().size(); ++index) {
                this.getChildren().setElementAt(((Expression)this.getChildren().elementAt(index)).normalize(normalizer), index);
            }
            return this;
        }
        for (int index = 0; index < this.getChildren().size(); ++index) {
            ((Expression)this.getChildren().elementAt(index)).validateNode();
        }
        ObjectExpression base = (ObjectExpression)this.getBaseExpression();
        base.getBaseExpression().normalize(normalizer);
        Expression foreignKeyJoin = base.getMapping().buildObjectJoinExpression((Expression)base, (Object)null, this.getSession());
        if (this.getOperator().getSelector() == 18) {
            foreignKeyJoin = foreignKeyJoin.not();
        }
        return foreignKeyJoin;
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        Vector oldChildren = this.children;
        this.children = NonSynchronizedVector.newInstance();
        for (int i = 0; i < oldChildren.size(); ++i) {
            this.addChild(((Expression)oldChildren.elementAt(i)).copiedVersionFrom(alreadyDone));
        }
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printCollection(this.getChildren(), printer);
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printJavaCollection(this.getChildren(), printer);
    }

    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        NonSynchronizedVector newChildren = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Vector)newChildren).addElement(((Expression)this.children.elementAt(i)).rebuildOn(newBase));
        }
        newLocalBase.setSelectIfOrderedBy(this.getBaseExpression().selectIfOrderedBy());
        FunctionExpression rebuilt = (FunctionExpression)newLocalBase.performOperator(this.getOperator(), newChildren);
        rebuilt.setResultType(this.getResultType());
        return rebuilt;
    }

    public void setLocalBase(Expression exp) {
        this.getBaseExpression().setLocalBase(exp);
    }

    public void setOperator(ExpressionOperator theOperator) {
        this.operator = theOperator;
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        if (this.getChildren().isEmpty()) {
            return (Expression)this.clone();
        }
        NonSynchronizedVector newChildren = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int index = 1; index < this.getChildren().size(); ++index) {
            ((Vector)newChildren).addElement(((Expression)this.children.elementAt(index)).twistedForBaseAndContext(newBase, context));
        }
        Expression oldBase = (Expression)this.getChildren().elementAt(0);
        return oldBase.twistedForBaseAndContext(newBase, context).performOperator(this.getOperator(), newChildren);
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        Object baseValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        NonSynchronizedVector arguments = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int index = 1; index < this.getChildren().size(); ++index) {
            if (this.getChildren().elementAt(index) instanceof Expression) {
                ((Vector)arguments).addElement(((Expression)this.getChildren().elementAt(index)).valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered));
                continue;
            }
            ((Vector)arguments).addElement(this.getChildren().elementAt(index));
        }
        if (baseValue instanceof Vector) {
            Vector<Object> baseVector = new Vector<Object>();
            Enumeration valuesToCompare = ((Vector)baseValue).elements();
            while (valuesToCompare.hasMoreElements()) {
                Object baseObject = valuesToCompare.nextElement();
                if (baseObject == null) {
                    baseVector.addElement(baseObject);
                    continue;
                }
                baseVector.addElement(this.getOperator().applyFunction(baseObject, arguments));
            }
            return baseVector;
        }
        if (baseValue == null) {
            return null;
        }
        return this.getOperator().applyFunction(baseValue, arguments);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.operator.toString());
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (this.getBaseExpression().isDataExpression()) {
            DatabaseField field = ((DataExpression)this.getBaseExpression()).getField();
            field = field == null ? new DatabaseField("*") : (DatabaseField)field.clone();
            if (this.hasResultType()) {
                field.setType(this.getResultType());
            } else {
                int selector = this.getOperator().getSelector();
                if (selector != 22 && selector != 23) {
                    field.setType(null);
                }
            }
            newFields.addElement(field);
        } else {
            DatabaseField field = new DatabaseField("*");
            field.setType(this.getResultType());
            newFields.addElement(field);
        }
        this.printSQL(printer);
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.baseExpression != null) {
            this.baseExpression.toString(writer, indent);
        }
    }
}

