/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.cache.MetadataHelper;

public class CacheInterceptorMetadata
extends ORMetadata {
    protected String m_interceptorClassName;

    public CacheInterceptorMetadata() {
        super("<cache-interceptor>");
    }

    public CacheInterceptorMetadata(Annotation cacheInterceptor, MetadataAccessibleObject accessibleObject) {
        super(cacheInterceptor, accessibleObject);
        this.m_interceptorClassName = ((Class)MetadataHelper.invokeMethod("interceptorClass", cacheInterceptor)).getName();
    }

    public void process(MetadataDescriptor descriptor, Class javaClass) {
        descriptor.setHasCacheInterceptor();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        classDescriptor.setCacheInterceptorClassName(this.m_interceptorClassName);
    }

    public String getInterceptorClassName() {
        return this.m_interceptorClassName;
    }

    public void setInterceptorClass(String interceptorClass) {
        this.m_interceptorClassName = interceptorClass;
    }
}

