/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.AMXCreateInfo;
import com.sun.appserv.management.config.AnyPropertyConfig;
import com.sun.appserv.management.config.DefaultValues;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.appserv.management.config.RefConfigReferent;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.appserv.management.config.SystemPropertyConfig;
import com.sun.appserv.management.helper.RefHelper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.UnregistrationListener;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.config.AMXConfigLoader;
import org.glassfish.admin.amx.config.AttrInfo;
import org.glassfish.admin.amx.config.ContainedTypeInfo;
import org.glassfish.admin.amx.config.CreateConfigArgSupport;
import org.glassfish.admin.amx.config.DelegateToConfigBeanDelegate;
import org.glassfish.admin.amx.config.NameMappingRegistry;
import org.glassfish.admin.amx.dotted.V3Pathname;
import org.glassfish.admin.amx.mbean.AMXImplBase;
import org.glassfish.admin.amx.mbean.ContainerSupport;
import org.glassfish.admin.amx.util.AMXConfigInfoResolver;
import org.glassfish.admin.amx.util.AttributeResolverHelper;
import org.glassfish.admin.amx.util.Issues;
import org.glassfish.admin.amx.util.SingletonEnforcer;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXConfigImplBase
extends AMXImplBase
implements AMXConfig,
DefaultValues {
    private final Class<?> mSupplementaryInterface;
    private static final String CREATE = "create";
    private static final String CREATE_PREFIX = "create";
    private static final String REMOVE_PREFIX = "remove";
    private static final String CONFIG_SUFFIX = "Config";
    private static final String FACTORY_SUFFIX = "Factory";
    private static final Class[] STRING_SIG = new Class[]{String.class};
    private static final Set<String> CR_PREFIXES = GSetUtil.newUnmodifiableStringSet("create", "remove");
    private volatile boolean _namesInited = false;

    public AMXConfigImplBase(String j2eeType, String fullType, ObjectName parentObjectName, Class<? extends AMX> theInterface, Class<?> supplementaryInterface, DelegateToConfigBeanDelegate delegate) {
        super(j2eeType, fullType, parentObjectName, theInterface, delegate);
        this.mSupplementaryInterface = supplementaryInterface;
    }

    private String getTypeString() {
        ConfigBean cb = this.getConfigBean();
        Class intf = cb.getProxyType();
        Package pkg = intf.getPackage();
        String result = intf.getName().substring(pkg.getName().length() + 1, intf.getName().length());
        Issues.getAMXIssues().notDone("getTypeString: how to get the XML element name from the ConfigBean");
        return result;
    }

    @Override
    public String getName() {
        ConfigBean cb = this.getConfigBean();
        return AMXConfigLoader.getName(cb, null);
    }

    @Override
    protected String _getPathnameType() {
        return V3Pathname.hyphenate(this.getTypeString());
    }

    @Override
    public Set<String> getContaineeJ2EETypes() {
        Set<String> j2eeTypes = super.getContaineeJ2EETypes();
        ContainedTypeInfo info = new ContainedTypeInfo(this.getConfigBean());
        j2eeTypes.addAll(info.findAllContainedJ2EETypes().keySet());
        return j2eeTypes;
    }

    @Override
    protected String asAMXAttributeName(String name) {
        String amxName = super.asAMXAttributeName(name);
        AMXConfigImplBase.cdebug("asAMXAttributeName: " + name);
        if (JMXUtil.getMBeanAttributeInfo(this.getMBeanInfo(), amxName) == null) {
            AttrInfo info = this.getConfigDelegate().getAttrInfo_AMX(name);
            if (info != null) {
                amxName = info.amxName();
                AMXConfigImplBase.cdebug("asAMXAttributeName: found match: " + info);
            } else {
                AMXConfigImplBase.cdebug("asAMXAttributeName: no match: " + name);
            }
        }
        return name;
    }

    protected boolean supportsProperties() {
        return PropertiesAccess.class.isAssignableFrom(this.getInterface());
    }

    protected boolean supportsSystemProperties() {
        return SystemPropertiesAccess.class.isAssignableFrom(this.getInterface());
    }

    @Override
    protected final Set<String> getSuperfluousMethods() {
        Method[] methods;
        Set<String> items = super.getSuperfluousMethods();
        for (Method m : methods = this.getClass().getMethods()) {
            String name = m.getName();
            if (!this.isRemoveConfig(name) && !this.isCreateConfig(name) || m.getParameterTypes().length > 1) continue;
            items.add(name);
        }
        return items;
    }

    private static void validatePropertyName(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Illegal property name: " + StringUtil.quote(propertyName));
        }
    }

    protected final <T extends AnyPropertyConfig> Map<String, String> asNameValuePairs(Map<String, T> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : items.keySet()) {
            AnyPropertyConfig any = (AnyPropertyConfig)items.get(name);
            String value = any.getValue();
            result.put(name, value);
        }
        return result;
    }

    protected final <T extends AnyPropertyConfig> AnyPropertyConfig getAnyPropertyConfig(Map<String, T> props, String propertyName) {
        return (AnyPropertyConfig)props.get(propertyName);
    }

    protected final <T extends AnyPropertyConfig> String getPropertyValue(Map<String, T> props, String propertyName) {
        AnyPropertyConfig prop = (AnyPropertyConfig)props.get(propertyName);
        return prop == null ? null : prop.getValue();
    }

    private void validateNameValue(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException("null");
        }
    }

    private final DelegateToConfigBeanDelegate getConfigDelegate() {
        return (DelegateToConfigBeanDelegate)DelegateToConfigBeanDelegate.class.cast(this.getDelegate());
    }

    private final ConfigBean getConfigBean() {
        return this.getConfigDelegate().getConfigBean();
    }

    @Override
    public final String getGroup() {
        return "configuration";
    }

    protected Map<String, PropertyConfig> getPropertyConfigMap() {
        return this.getSelf(PropertiesAccess.class).getPropertyConfigMap();
    }

    protected Map<String, SystemPropertyConfig> getSystemPropertyConfigMap() {
        return this.getSelf(SystemPropertiesAccess.class).getSystemPropertyConfigMap();
    }

    @Override
    public String resolveAttributeValue(String varString) {
        if (!AttributeResolverHelper.needsResolving(varString)) {
            return varString;
        }
        return new AttributeResolverHelper(this).resolve(varString);
    }

    @Override
    public String resolveAttribute(String attrName) {
        try {
            Object value = this.getAttribute(attrName);
            return this.resolveAttributeValue(value == null ? null : "" + value);
        }
        catch (AttributeNotFoundException e) {
            System.out.println("resolveAttribute: Attribute not found: " + attrName);
            return null;
        }
    }

    @Override
    public Boolean resolveBoolean(String attrName) {
        return Boolean.parseBoolean(this.resolveAttribute(attrName));
    }

    @Override
    public Integer resolveInteger(String attrName) {
        return Integer.parseInt(this.resolveAttribute(attrName));
    }

    @Override
    public Long resolveLong(String attrName) {
        return Long.parseLong(this.resolveAttribute(attrName));
    }

    @Override
    public AttributeList resolveAttributes(String[] attrNames) {
        Issues.getAMXIssues().notDone("resolveAttributes: use annotations to create the correct type");
        AttributeList attrs = this.getAttributes(attrNames);
        AttributeList resolvedAttrs = new AttributeList();
        for (Object o : attrs) {
            Attribute r = (Attribute)o;
            Object value = r.getValue();
            if (value instanceof String && AttributeResolverHelper.needsResolving((String)value)) {
                String resolvedValue = this.resolveAttributeValue((String)value);
                r = new Attribute(r.getName(), resolvedValue);
            }
            resolvedAttrs.add(r);
        }
        return resolvedAttrs;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] superInfos = super.getNotificationInfo();
        String description = "";
        String[] notifTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo attributeChange = new MBeanNotificationInfo(notifTypes, AttributeChangeNotification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{attributeChange};
        MBeanNotificationInfo[] allInfos = JMXUtil.mergeMBeanNotificationInfos(superInfos, selfInfos);
        return allInfos;
    }

    protected void preRemove(ObjectName objectName) {
        AMXConfig amxConfig = this.getProxy(objectName, AMXConfig.class);
        if (amxConfig instanceof RefConfigReferent) {
            this.debug("*** Removing all references to ", objectName);
            Set failures = RefHelper.removeAllRefsTo((RefConfigReferent)((Object)amxConfig), true);
            if (failures.size() != 0) {
                this.debug((Object)("FAILURE removing references to " + objectName + ": " + CollectionUtil.toString(Util.toObjectNames(failures))));
            }
        } else {
            this.debug("*** not a RefConfigReferent: ", objectName);
        }
    }

    protected ObjectName preRemove(Map<String, ObjectName> items, String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        ObjectName objectName = items.get(name);
        if (objectName == null) {
            throw new IllegalArgumentException("Item not found: " + name);
        }
        this.preRemove(objectName);
        return objectName;
    }

    private boolean isRemoveConfig(String operationName) {
        return operationName.startsWith(REMOVE_PREFIX) && operationName.endsWith(CONFIG_SUFFIX);
    }

    private boolean isRemoveConfig(String operationName, Object[] args, String[] types) {
        boolean isRemove;
        int numArgs = args == null ? 0 : args.length;
        boolean bl = isRemove = numArgs <= 1 && this.isRemoveConfig(operationName);
        if (isRemove && numArgs == 1) {
            isRemove = types[0].equals(String.class.getName());
        }
        return isRemove;
    }

    private boolean isCreateConfig(String operationName) {
        return operationName.startsWith("create") && operationName.endsWith(CONFIG_SUFFIX);
    }

    private boolean isGenericCreateConfig(String operationName) {
        return operationName.equals("createConfig");
    }

    private Method getCreateMethod(String operationName, String[] types) throws ClassNotFoundException {
        Class[] signature = ClassUtil.signatureFromClassnames(types);
        Class myInterface = TypeCast.asClass(this.getInterface());
        Method m = ClassUtil.findMethod(myInterface, operationName, signature);
        if (m == null) {
            throw new IllegalArgumentException("Can't find method " + operationName);
        }
        if (!AMXConfig.class.isAssignableFrom(m.getReturnType())) {
            throw new IllegalArgumentException("Class " + m.getReturnType().getName() + " is not a subclass of AMXConfig");
        }
        return m;
    }

    private void checkPropertiesSupported(Class<? extends AMXConfig> intf, CreateConfigArgSupport argSpt) {
        if (argSpt.getProperties().keySet().size() != 0 && !PropertiesAccess.class.isAssignableFrom(intf)) {
            throw new IllegalArgumentException("Properties specified, but not supported by " + intf.getName());
        }
        if (argSpt.getSystemProperties().keySet().size() != 0 && !SystemPropertiesAccess.class.isAssignableFrom(intf)) {
            throw new IllegalArgumentException("System properties specified, but not supported by " + intf.getName());
        }
    }

    private AMXCreateInfo getAMXCreateInfo(Method m, Class<? extends AMXConfig> intf, int numArgs) {
        AMXCreateInfo amxCreateInfo = m.getAnnotation(AMXCreateInfo.class);
        if (amxCreateInfo == null && (amxCreateInfo = intf.getAnnotation(AMXCreateInfo.class)) == null) {
            AMXConfigImplBase.cdebug("No AMXCreateInfo found for interface " + intf.getName());
        }
        if (amxCreateInfo == null && numArgs != 0) {
            throw new IllegalArgumentException("Method " + m.getName() + " must be annotated with " + AMXCreateInfo.class.getName());
        }
        return amxCreateInfo;
    }

    private void checkJ2EETypeMatches(String j2eeType, String operationName) {
        String altJ2EEType = "X-" + operationName.substring("create".length(), operationName.length());
        if (!j2eeType.equals(altJ2EEType)) {
            throw new IllegalArgumentException("checkJ2EETypeMatches: j2eeType " + j2eeType + " != " + altJ2EEType);
        }
    }

    private static List<ConfigSupport.AttributeChanges> toAttributeChanges(Map<String, Object> values) {
        ArrayList<ConfigSupport.AttributeChanges> changes = new ArrayList<ConfigSupport.AttributeChanges>();
        for (String name : values.keySet()) {
            Object value = values.get(name);
            if (value == null || value instanceof String) {
                changes.add(new ConfigSupport.SingleAttributeChange(name, (String)value));
                continue;
            }
            changes.add(new ConfigSupport.MultipleAttributeChanges(name, (String[])value));
        }
        return changes;
    }

    protected ObjectName createConfig(String operationName, Object[] args, String[] types) throws ClassNotFoundException, TransactionFailure {
        if (!this.isCreateConfig(operationName)) {
            throw new IllegalArgumentException("Illegal method name for create: " + operationName);
        }
        Object result = null;
        CreateConfigArgSupport argSpt = new CreateConfigArgSupport(operationName, args, types);
        Method m = this.getCreateMethod(operationName, types);
        Class returnType = TypeCast.asClass(m.getReturnType());
        this.checkPropertiesSupported(returnType, argSpt);
        String j2eeType = Util.getJ2EEType(returnType);
        this.checkJ2EETypeMatches(j2eeType, operationName);
        AMXConfigImplBase.cdebug("createConfig: j2eeType = " + j2eeType + ", return type = " + returnType.getName());
        AMXCreateInfo amxCreateInfo = this.getAMXCreateInfo(m, returnType, argSpt.numArgs());
        String[] paramNames = amxCreateInfo.paramNames();
        AMXConfigImplBase.cdebug("createConfig:  paramNames = {" + StringUtil.toString(paramNames) + "}");
        argSpt.addExplicitAttrs(paramNames);
        ContainedTypeInfo subInfo = new ContainedTypeInfo(this.getConfigBean());
        Class<? extends ConfigBeanProxy> newItemClass = subInfo.getConfigBeanProxyClassFor(j2eeType);
        if (newItemClass == null) {
            throw new IllegalArgumentException("Can't find class for j2eeType " + j2eeType);
        }
        AMXConfigInfoResolver resolver = subInfo.getAMXConfigInfoResolverFor(j2eeType);
        if (resolver.amxInterface() != returnType) {
            throw new IllegalArgumentException();
        }
        AMXConfigImplBase.cdebug("calling ConfigSupport.createAndSet() ");
        ConfigBean newConfigBean = null;
        List<ConfigSupport.AttributeChanges> changes = AMXConfigImplBase.toAttributeChanges(argSpt.getAttrs());
        PropertiesCallback callback = new PropertiesCallback(argSpt.getProperties(), argSpt.getSystemProperties());
        try {
            newConfigBean = ConfigSupport.createAndSet(this.getConfigBean(), newItemClass, changes, (ConfigSupport.TransactionCallBack<WriteableView>)callback);
        }
        catch (Throwable t) {
            AMXConfigImplBase.cdebug(ExceptionUtil.toString(t));
            throw new RuntimeException(t);
        }
        AMXConfigLoader amxLoader = SingletonEnforcer.get(AMXConfigLoader.class);
        amxLoader.handleConfigBean(newConfigBean, true);
        ObjectName objectName = newConfigBean.getObjectName();
        AMXConfigImplBase.cdebug("NEW OBJECTNAME:  " + objectName);
        AMXConfig newAMX = (AMXConfig)AMXConfig.class.cast(this.getProxyFactory().getProxy(objectName));
        this.setAllProperties(newAMX, argSpt.getProperties(), argSpt.getSystemProperties());
        return objectName;
    }

    private void setAllProperties(AMXConfig amxConfig, Map<String, String> properties, Map<String, String> systemProperties) {
        String propValue;
        Object pa;
        if (properties.keySet().size() != 0) {
            pa = (PropertiesAccess)PropertiesAccess.class.cast(amxConfig);
            for (String propName : properties.keySet()) {
                propValue = properties.get(propName);
                AMXConfigImplBase.cdebug("################## Creating property " + propName + " = " + propValue);
                try {
                    pa.createPropertyConfig(propName, propValue);
                }
                catch (Throwable t) {
                    AMXConfigImplBase.cdebug(ExceptionUtil.toString(ExceptionUtil.getRootCause(t)));
                }
            }
        }
        if (systemProperties.keySet().size() != 0) {
            pa = (SystemPropertiesAccess)SystemPropertiesAccess.class.cast(amxConfig);
            for (String propName : systemProperties.keySet()) {
                propValue = systemProperties.get(propName);
                this.debug((Object)("################## Creating System property " + propName + " = " + propValue));
                pa.createSystemPropertyConfig(propName, propValue);
            }
        }
    }

    protected boolean mySleep(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            interrupted = true;
        }
        return interrupted;
    }

    protected String operationNameToSimpleClassname(String operationName) {
        return StringUtil.findAndStripPrefix(CR_PREFIXES, operationName);
    }

    @Override
    protected String operationNameToJ2EEType(String operationName) {
        String j2eeType = null;
        j2eeType = this.isRemoveConfig(operationName) || this.isCreateConfig(operationName) ? "X-" + this.operationNameToSimpleClassname(operationName) : super.operationNameToJ2EEType(operationName);
        return j2eeType;
    }

    public final void removeConfig(ObjectName containeeObjectName) {
        ContainerSupport containerSupport = this.getContainerSupport();
        this.preRemove(containeeObjectName);
        AMXConfigImplBase child = (AMXConfigImplBase)this.get__ObjectRef(containeeObjectName);
        try {
            AMXConfigImplBase.cdebug("REMOVING config of class " + child.getConfigBean().getProxyType().getName() + " from  parent of type " + this.getConfigBean().getProxyType().getName() + ", ObjectName = " + JMXUtil.toString(containeeObjectName));
            ConfigSupport.deleteChild(this.getConfigBean(), child.getConfigBean());
        }
        catch (TransactionFailure tf) {
            throw new RuntimeException("Transaction failure deleting " + JMXUtil.toString(containeeObjectName), tf);
        }
        UnregistrationListener myListener = new UnregistrationListener(this.getMBeanServer(), containeeObjectName);
        long TIMEOUT_MILLIS = 10000L;
        boolean unregisteredOK = myListener.waitForUnregister(10000L);
        if (!unregisteredOK) {
            throw new RuntimeException("Something went wrong unregistering MBean " + JMXUtil.toString(containeeObjectName));
        }
    }

    public final void removeConfig(String j2eeType, String name) {
        ContainerSupport containerSupport = this.getContainerSupport();
        ObjectName containeeObjectName = containerSupport.getContaineeObjectName(j2eeType, name);
        if (containeeObjectName == null) {
            throw new RuntimeException(new InstanceNotFoundException("No MBean named " + name + " of j2eeType " + j2eeType + " found."));
        }
        this.removeConfig(containeeObjectName);
    }

    protected void removeConfig(String operationName) {
        String j2eeType = this.operationNameToJ2EEType(operationName);
        ContainerSupport containerSupport = this.getContainerSupport();
        ObjectName containeeObjectName = containerSupport.getContaineeObjectName(j2eeType);
        if (containeeObjectName == null) {
            throw new RuntimeException(new InstanceNotFoundException(j2eeType));
        }
        this.removeConfig(containeeObjectName);
    }

    protected void removeConfig(String operationName, Object[] args, String[] types) throws InvocationTargetException {
        if (args == null || args.length == 0) {
            AMXConfigImplBase.cdebug("removeConfig: by operation name only");
            this.removeConfig(operationName);
        } else if (args.length == 1) {
            AMXConfigImplBase.cdebug("removeConfig: by operationName + name");
            this.removeConfig(this.operationNameToJ2EEType(operationName), (String)args[0]);
        } else if (args.length == 2) {
            AMXConfigImplBase.cdebug("removeConfig: by  j2eeType + name");
            if (!operationName.equals("removeConfig")) {
                throw new IllegalArgumentException();
            }
            this.removeConfig((String)args[0], (String)args[1]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        this.debugMethod(operationName, args);
        if (this.isRemoveConfig(operationName, args, types)) {
            try {
                this.removeConfig(operationName, args, types);
            }
            catch (InvocationTargetException e) {
                throw new MBeanException(e);
            }
        } else if (this.isCreateConfig(operationName)) {
            try {
                result = this.createConfig(operationName, args, types);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        } else {
            result = super.invokeManually(operationName, args, types);
        }
        return result;
    }

    public String[] getAnonymousElementList(String elementName) {
        return this.getConfigDelegate().getAnonymousElementList(elementName);
    }

    public String[] modifyAnonymousElementList(String elementName, String cmd, String[] values) {
        return this.getConfigDelegate().modifyAnonymousElementList(elementName, cmd, values);
    }

    public String getConfigName() {
        return this.getKeyProperty("X-ConfigConfig");
    }

    public void sendConfigCreatedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigCreated", "com.sun.appserv.management.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    public void sendConfigRemovedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigRemoved", "com.sun.appserv.management.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    @Override
    public String getDefaultValue(String amxName) {
        Class myIntf = this.getConfigBean().getProxyType();
        Map<String, String> defaultValues = this._getDefaultValues(myIntf);
        String xmlName = NameMappingRegistry.getInstance(this.getJ2EEType()).getXMLName(amxName);
        return defaultValues.get(xmlName);
    }

    final Map<String, String> _getDefaultValues(Class<? extends ConfigBeanProxy> intf) {
        Method[] methods;
        HashMap<String, String> result = new HashMap<String, String>();
        for (Method m : methods = intf.getMethods()) {
            String value;
            boolean emptyDefault;
            if (!JMXUtil.isIsOrGetter(m)) continue;
            String attrName = JMXUtil.getAttributeName(m);
            org.jvnet.hk2.config.Attribute attrAnn = m.getAnnotation(org.jvnet.hk2.config.Attribute.class);
            if (attrAnn == null || (emptyDefault = (value = attrAnn.defaultValue()).equals("\u0000"))) continue;
            result.put(attrName, "" + attrAnn.defaultValue());
        }
        return result;
    }

    @Override
    public final Map<String, String> getDefaultValues(String j2eeTypeIn) {
        String j2eeType = j2eeTypeIn == null ? this.getJ2EEType() : j2eeTypeIn;
        ContainedTypeInfo info = new ContainedTypeInfo(this.getConfigBean());
        Class<? extends ConfigBeanProxy> intf = info.getConfigBeanProxyClassFor(j2eeTypeIn);
        if (intf == null) {
            throw new IllegalArgumentException("Illegal j2eeType: " + j2eeType);
        }
        return this._getDefaultValues(intf);
    }

    private synchronized void initNames() {
        if (!this._namesInited) {
            DelegateToConfigBeanDelegate delegate = this.getConfigDelegate();
            String[] attrNames = this.getAttributeNames();
            delegate.initNameMapping(attrNames);
            this._namesInited = true;
        }
    }

    @Override
    protected synchronized void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            this.initNames();
        }
    }

    void issueAttributeChangeForXmlAttrName(String xmlAttrName, Object oldValue, Object newValue, long whenChanged) {
        if (!this._namesInited) {
            this.initNames();
        }
        String attrType = String.class.getName();
        String amxAttrName = NameMappingRegistry.getInstance(this.getJ2EEType()).getAMXName(xmlAttrName);
        if (amxAttrName == null) {
            AMXConfigImplBase.cdebug("issueAttributeChangeForXmlAttrName: can't find AMX name for: " + xmlAttrName + ", using xmlName for now");
            amxAttrName = xmlAttrName;
        } else {
            attrType = this.getAttributeType(amxAttrName);
        }
        if (oldValue != newValue) {
            this.sendAttributeChangeNotification("", amxAttrName, attrType, whenChanged, oldValue, newValue);
        }
    }

    @Override
    protected String attributeNameToPathNameValueName(String amxAttrName) {
        String xmlName = NameMappingRegistry.getInstance(this.getJ2EEType()).getXMLName(amxAttrName);
        return xmlName == null ? super.attributeNameToPathNameValueName(amxAttrName) : xmlName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertiesCallback
    implements ConfigSupport.TransactionCallBack<WriteableView> {
        private final Map<String, String> mProperties;
        private final Map<String, String> mSystemProperties;

        public PropertiesCallback(Map<String, String> properties, Map<String, String> systemProperties) {
            this.mProperties = properties;
            this.mSystemProperties = systemProperties;
        }

        @Override
        public void performOn(WriteableView item) throws TransactionFailure {
        }
    }
}

