/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.base.Util;
import java.io.File;
import javax.management.ObjectName;
import org.glassfish.admin.amx.logging.AMXMBeanRootLogger;
import org.glassfish.admin.amx.logging.AMXServerLogger;
import org.glassfish.admin.amx.util.Issues;

public final class BootUtil {
    private final String mAppserverDomainName;
    private final File mInstanceRoot;
    private final String mAMX_JMXDomain;
    private static BootUtil INSTANCE = null;
    private boolean mAMXReady;
    private final boolean mOfflineAMX;

    private BootUtil(boolean offline) {
        AMXServerLogger.getInstance();
        AMXMBeanRootLogger.getInstance();
        this.mInstanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"));
        this.mAppserverDomainName = this.mInstanceRoot.getName();
        this.mAMX_JMXDomain = "amx";
        this.mAMXReady = false;
        this.mOfflineAMX = offline;
    }

    public File getInstanceRoot() {
        return this.mInstanceRoot;
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    public String getServerName() {
        Issues.getAMXIssues().notDone("BootUtil.getServerName()");
        return "server";
    }

    public static synchronized void init(boolean offline) {
        INSTANCE = new BootUtil(offline);
    }

    public boolean getOffline() {
        return this.mOfflineAMX;
    }

    public static synchronized BootUtil getInstance() {
        if (INSTANCE == null) {
            throw new IllegalArgumentException("must call init() first");
        }
        return INSTANCE;
    }

    public boolean getAMXReady() {
        return this.mAMXReady;
    }

    public void setAMXReady(boolean ready) {
        if (this.mAMXReady && !ready) {
            throw new IllegalArgumentException();
        }
        this.mAMXReady = ready;
    }

    private ObjectName getObjectName(String props) {
        String domain = this.getAMXSupportJMXDomain();
        return Util.newObjectName(domain, props);
    }

    public String getAMXSupportJMXDomain() {
        return this.getAMXJMXDomainName() + "-support";
    }

    public String getAMXJMXDomainName() {
        return this.mAMX_JMXDomain;
    }
}

