/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public final class MBeanInfoConverter {
    private final Map<Class, MBeanInfo> mConvertedInfos = Collections.synchronizedMap(new HashMap());
    private static MBeanInfoConverter INSTANCE = null;
    private static final Map<String, Class> NAMES_TO_CLASSES = Collections.synchronizedMap(new HashMap());
    private static final String OBJECT_NAME_SUFFIX = "ObjectName";
    private static final String SET_SUFFIX = "Set";
    private static final String MAP_SUFFIX = "Map";
    private static final String LIST_SUFFIX = "List";
    private static final String OBJECT_NAME_MAP_SUFFIX = "ObjectNameMap";
    private static final String OBJECT_NAME_SET_SUFFIX = "ObjectNameSet";
    private static final String OBJECT_NAME_LIST_SUFFIX = "ObjectNameList";

    private MBeanInfoConverter() {
    }

    public static synchronized MBeanInfoConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MBeanInfoConverter();
        }
        return INSTANCE;
    }

    protected static Class toClass(String className) {
        Class<?> theClass = NAMES_TO_CLASSES.get(className);
        if (theClass != null) {
            return theClass;
        }
        try {
            theClass = ClassUtil.getClassFromName(className);
            NAMES_TO_CLASSES.put(className, theClass);
            return theClass;
        }
        catch (ClassNotFoundException e) {
            assert (false);
            throw new RuntimeException(e);
        }
    }

    protected void trace(Object o) {
    }

    private final MBeanAttributeInfo convert(MBeanAttributeInfo info) {
        MBeanAttributeInfo result = info;
        String name = info.getName();
        Class<ObjectName> type = MBeanInfoConverter.toClass(info.getType());
        String newName = null;
        Class<ObjectName> newType = type;
        if (AMX.class.isAssignableFrom(type)) {
            newName = name + OBJECT_NAME_SUFFIX;
            newType = ObjectName.class;
        } else if (name.endsWith(SET_SUFFIX) && !name.endsWith(OBJECT_NAME_SET_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, SET_SUFFIX, OBJECT_NAME_SET_SUFFIX);
        } else if (name.endsWith(MAP_SUFFIX) && !name.endsWith(OBJECT_NAME_MAP_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, MAP_SUFFIX, OBJECT_NAME_MAP_SUFFIX);
        } else if (name.endsWith(LIST_SUFFIX) && !name.endsWith(OBJECT_NAME_LIST_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, LIST_SUFFIX, OBJECT_NAME_LIST_SUFFIX);
        }
        if (newName != null) {
            this.trace(ClassUtil.stripPackageName(type.getName()) + " " + name + " => " + ClassUtil.stripPackageName(newType.getName()) + " " + newName);
            result = new MBeanAttributeInfo(newName, newType.getName(), info.getDescription(), info.isReadable(), info.isWritable(), info.isIs());
        }
        return result;
    }

    protected static String convertMethodName(String srcName, String srcSuffix, String resultSuffix) {
        return StringUtil.replaceSuffix(srcName, srcSuffix, resultSuffix);
    }

    private final MBeanOperationInfo convert(MBeanOperationInfo info) {
        MBeanOperationInfo result = info;
        String name = info.getName();
        Class<ObjectName> returnClass = MBeanInfoConverter.toClass(info.getReturnType());
        String newName = null;
        Class<ObjectName> newReturnClass = returnClass;
        if (AMX.class.isAssignableFrom(returnClass)) {
            newReturnClass = ObjectName.class;
            newName = name.startsWith("create") ? name : name + OBJECT_NAME_SUFFIX;
        } else if (Map.class.isAssignableFrom(returnClass) && name.endsWith(MAP_SUFFIX) && !name.endsWith(OBJECT_NAME_MAP_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, MAP_SUFFIX, OBJECT_NAME_MAP_SUFFIX);
        } else if (Set.class.isAssignableFrom(returnClass) && name.endsWith(SET_SUFFIX) && !name.endsWith(OBJECT_NAME_SET_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, SET_SUFFIX, OBJECT_NAME_SET_SUFFIX);
        } else if (Set.class.isAssignableFrom(returnClass) && name.endsWith(LIST_SUFFIX) && !name.endsWith(OBJECT_NAME_LIST_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, LIST_SUFFIX, OBJECT_NAME_LIST_SUFFIX);
        }
        if (newName != null) {
            this.trace(ClassUtil.stripPackageName(returnClass.getName()) + " " + name + "(...)" + " => " + ClassUtil.stripPackageName(newReturnClass.getName()) + " " + newName + "(...)");
            result = new MBeanOperationInfo(newName, info.getDescription(), info.getSignature(), newReturnClass.getName(), info.getImpact());
        }
        return result;
    }

    private final MBeanAttributeInfo[] convertAttributes(MBeanAttributeInfo[] origInfos) {
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[origInfos.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = this.convert(origInfos[i]);
        }
        return infos;
    }

    private final MBeanOperationInfo[] convertOperations(MBeanOperationInfo[] origInfos) {
        MBeanOperationInfo[] infos = new MBeanOperationInfo[origInfos.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = this.convert(origInfos[i]);
        }
        return infos;
    }

    private final MBeanInfo find(Class theInterface) {
        return this.mConvertedInfos.get(theInterface);
    }

    public final MBeanInfo convert(Class theInterface, MBeanAttributeInfo[] extraAttributeInfos) {
        MBeanInfo result = null;
        result = this.find(theInterface);
        if (result == null) {
            MBeanInfo origInfo = JMXUtil.interfaceToMBeanInfo(theInterface);
            MBeanAttributeInfo[] origAttrInfos = origInfo.getAttributes();
            MBeanAttributeInfo[] attrInfos = extraAttributeInfos == null ? origAttrInfos : JMXUtil.mergeMBeanAttributeInfos(origAttrInfos, extraAttributeInfos);
            result = new MBeanInfo(origInfo.getClassName(), origInfo.getDescription(), this.convertAttributes(attrInfos), origInfo.getConstructors(), this.convertOperations(origInfo.getOperations()), origInfo.getNotifications());
            this.mConvertedInfos.put(theInterface, result);
        }
        return result;
    }
}

