/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.AuthRealmConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.ext.realm.RealmsMgr;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.User;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.internal.api.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RealmsMgrImpl
extends AMXNonConfigImplBase
implements RealmsMgr {
    private final RealmsManager mRealmsManager = Globals.getDefaultHabitat().getComponent(RealmsManager.class);
    private boolean realmsLoaded = false;
    private static final String ADMIN_REALM = "admin-realm";
    private static final String ANONYMOUS_USER = "anonymous";
    private static final String FILE_REALM_CLASSNAME = "com.sun.enterprise.security.auth.realm.file.FileRealm";

    public RealmsMgrImpl(ObjectName containerObjectName) {
        super("X-RealmsMgr", "X-RealmsMgr", containerObjectName, RealmsMgr.class, null);
    }

    private synchronized void loadRealms() {
        if (this.realmsLoaded) {
            return;
        }
        this.realmsLoaded = true;
        ConfigConfig config = this.getDomainRoot().getDomainConfig().getConfigsConfig().getConfigConfigMap().values().iterator().next();
        SecurityServiceConfig ss = config.getSecurityServiceConfig();
        Map<String, AuthRealmConfig> authRealmConfigs = ss.getAuthRealmConfigMap();
        ArrayList<String> goodRealms = new ArrayList<String>();
        for (AuthRealmConfig authRealm : authRealmConfigs.values()) {
            Map<String, PropertyConfig> propConfigs = authRealm.getPropertyConfigMap();
            Properties props = new Properties();
            for (PropertyConfig p : propConfigs.values()) {
                String value = p.resolveAttribute("Value");
                props.setProperty(p.getName(), value);
            }
            try {
                Realm.instantiate(authRealm.getName(), authRealm.getClassname(), props);
                goodRealms.add(authRealm.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (goodRealms.size() != 0) {
            String goodRealm = (String)goodRealms.iterator().next();
            try {
                String defaultRealm = ss.getDefaultRealm();
                Realm r = Realm.getInstance(defaultRealm);
                Realm.setDefaultRealm(defaultRealm);
            }
            catch (Exception e) {
                Realm.setDefaultRealm((String)goodRealms.iterator().next());
            }
        }
    }

    private static String[] toArray(List<String> l) {
        return l.toArray(new String[l.size()]);
    }

    @Override
    public String[] getRealmNames() {
        this.loadRealms();
        List<Enumeration> items = ListUtil.newList(this.mRealmsManager.getRealmNames());
        return RealmsMgrImpl.toArray(items);
    }

    @Override
    public String[] getPredefinedAuthRealmClassNames() {
        List<String> items = this.mRealmsManager.getPredefinedAuthRealmClassNames();
        return RealmsMgrImpl.toArray(items);
    }

    @Override
    public String getDefaultRealmName() {
        return this.mRealmsManager.getDefaultRealmName();
    }

    @Override
    public void setDefaultRealmName(String realmName) {
        this.mRealmsManager.setDefaultRealmName(realmName);
    }

    private Realm getRealm(String realmName) {
        this.loadRealms();
        Realm realm = this.mRealmsManager.getFromLoadedRealms(realmName);
        if (realm == null) {
            throw new IllegalArgumentException("No such realm: " + realmName);
        }
        return realm;
    }

    @Override
    public void addUser(String realmName, String user, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.addUser(user, password, groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateUser(String realmName, String existingUser, String newUser, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.updateUser(existingUser, newUser, password, groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeUser(String realmName, String user) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.removeUser(user);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean supportsUserManagement(String realmName) {
        return this.getRealm(realmName).supportsUserManagement();
    }

    private void checkSupportsUserManagement(String realmName) {
        if (!this.supportsUserManagement(realmName)) {
            throw new IllegalStateException("Realm " + realmName + " does not support user management");
        }
    }

    @Override
    public String[] getUserNames(String realmName) {
        try {
            List<Enumeration> names = ListUtil.newList(this.getRealm(realmName).getUserNames());
            return RealmsMgrImpl.toArray(names);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getGroupNames(String realmName) {
        try {
            List<Enumeration> names = ListUtil.newList(this.getRealm(realmName).getGroupNames());
            return RealmsMgrImpl.toArray(names);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getGroupNames(String realmName, String user) {
        try {
            return RealmsMgrImpl.toArray(ListUtil.newList(this.getRealm(realmName).getGroupNames(user)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> getUserAttributes(String realmName, String username) {
        try {
            User user = this.getRealm(realmName).getUser(username);
            HashMap<String, Object> m = new HashMap<String, Object>();
            List<Enumeration> attrNames = ListUtil.newList(user.getAttributeNames());
            for (String string : attrNames) {
                m.put(string, user.getAttribute(string));
            }
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void debug(String s) {
        System.out.println("##### " + s);
    }

    @Override
    public boolean getAnonymousLogin() {
        DomainRoot domainRoot = this.getDomainRoot();
        Map<String, ConfigConfig> configs = domainRoot.getDomainConfig().getConfigsConfig().getConfigConfigMap();
        AuthRealmConfig adminFileAuthRealm = null;
        block0: for (ConfigConfig config : configs.values()) {
            for (AuthRealmConfig auth : config.getSecurityServiceConfig().getAuthRealmConfigMap().values()) {
                if (!auth.getName().equals(ADMIN_REALM)) continue;
                adminFileAuthRealm = auth;
                continue block0;
            }
        }
        if (adminFileAuthRealm == null) {
            throw new IllegalStateException("Cannot find admin realm");
        }
        String fileRealmClassName = adminFileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals(FILE_REALM_CLASSNAME)) {
            return false;
        }
        Map<String, PropertyConfig> props = adminFileAuthRealm.getPropertyConfigMap();
        PropertyConfig keyfileProp = props.get("file");
        if (keyfileProp == null) {
            throw new IllegalStateException("Cannot find property 'file'");
        }
        String keyFile = keyfileProp.resolveAttribute("Value");
        if (keyFile == null) {
            throw new IllegalStateException("Cannot find key file");
        }
        String[] usernames = this.getUserNames(adminFileAuthRealm.getName());
        return usernames.length == 1 && usernames[0].equals(ANONYMOUS_USER);
    }
}

