/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.management.base.SystemStatus;
import com.sun.appserv.management.base.UnprocessedConfigChange;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.mbeanserver.UnprocessedConfigListener;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemStatusImpl
extends AMXNonConfigImplBase
implements SystemStatus {
    public SystemStatusImpl(ObjectName parentObjectName) {
        super("X-SystemStatus", "X-SystemStatus", parentObjectName, SystemStatus.class, null);
    }

    private Habitat getHabitat() {
        return Globals.getDefaultHabitat();
    }

    @Override
    public Map<String, Object> pingJDBCConnectionPool(String poolName) {
        ConnectorRuntime connRuntime;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean pingable = false;
        Habitat habitat = this.getHabitat();
        JDBCConnectionPoolConfig cfg = this.getDomainRoot().getDomainConfig().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(poolName);
        if (cfg == null) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", "The pool name " + poolName + " does not exist");
            return result;
        }
        if (habitat == null) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            connRuntime = habitat.getComponent(ConnectorRuntime.class, null);
        }
        catch (ComponentException e) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", ExceptionUtil.toString(e));
            return result;
        }
        try {
            pingable = connRuntime.pingConnectionPool(poolName);
        }
        catch (ResourceException e) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", ExceptionUtil.toString(e));
            return result;
        }
        result.put("PingSucceededKey", pingable);
        return result;
    }

    private static void xdebug(String s) {
        System.out.println("### " + s);
    }

    private static String str(Object o) {
        return o == null ? null : "" + o;
    }

    private ObjectName sourceToObjectName(Object source) {
        ObjectName objectName = null;
        if (source instanceof ConfigBean) {
            objectName = ((ConfigBean)source).getObjectName();
        } else if (source instanceof ConfigBeanProxy) {
            objectName = ((ConfigBean)Dom.unwrap((ConfigBeanProxy)source)).getObjectName();
        } else {
            SystemStatusImpl.xdebug("UnprocessedConfigChange.sourceToObjectName: source is something else");
        }
        return objectName;
    }

    @Override
    public List<Object[]> getUnprocessedConfigChanges() {
        UnprocessedConfigListener unp = this.getHabitat().getComponent(UnprocessedConfigListener.class);
        List<UnprocessedChangeEvents> items = unp.getUnprocessedChangeEvents();
        ArrayList<Object[]> changesObjects = new ArrayList<Object[]>();
        SystemStatusImpl.xdebug("UnprocessedConfigChange: processing events: " + items.size());
        for (UnprocessedChangeEvents events : items) {
            for (UnprocessedChangeEvent event : events.getUnprocessed()) {
                SystemStatusImpl.xdebug("UnprocessedConfigChange: event: " + event);
                String reason = event.getReason();
                PropertyChangeEvent pce = event.getEvent();
                long when = event.getWhen();
                ObjectName objectName = this.sourceToObjectName(pce.getSource());
                UnprocessedConfigChange ucc = new UnprocessedConfigChange(pce.getPropertyName(), SystemStatusImpl.str(pce.getOldValue()), SystemStatusImpl.str(pce.getNewValue()), objectName, reason);
                SystemStatusImpl.xdebug("UnprocessedConfigChange: " + ucc);
                changesObjects.add(ucc.toArray());
            }
        }
        return changesObjects;
    }
}

