/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.ResourceUtils;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-resource-ref")
@Scoped(value=PerLookup.class)
@I18n(value="create.resource.ref")
public class CreateResourceRef
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateResourceRef.class);
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true)
    String target = "server";
    @Param(name="reference_name", primary=true)
    String refName;
    @Inject
    Server[] servers;
    @Inject
    AdminObjectResource[] adminObjectResources;
    @Inject
    ConnectorResource[] connectorResources;
    @Inject
    CustomResource[] customResources;
    @Inject
    ExternalJndiResource[] externalJndiResources;
    @Inject
    JdbcResource[] jdbcResources;
    @Inject
    MailResource[] mailResources;
    @Inject
    PersistenceManagerFactoryResource[] persistenceMgrFactoryResources;
    @Inject
    Resources resources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isResourceExists()) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.resourceDoesNotExist", "Resource {0} does not exist", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            for (Server server : this.servers) {
                if (!server.getName().equals(this.target)) continue;
                if (ResourceUtils.isResourceRefExists(server, this.refName)) {
                    report.setMessage(localStrings.getLocalString("create.resource.ref.existsAlready", "Resource ref {0} already exists", this.refName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ResourceUtils.createResourceRef(server, this.enabled.toString(), this.refName);
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.failed", "Resource ref {0} creation failed", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
            return;
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.failed", "Resource ref {0} creation failed", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }

    private boolean isResourceExists() {
        for (AdminObjectResource adminObjectResource : this.adminObjectResources) {
            if (!adminObjectResource.getJndiName().equals(this.refName)) continue;
            return true;
        }
        for (Resource resource : this.connectorResources) {
            if (!resource.getJndiName().equals(this.refName)) continue;
            return true;
        }
        for (Resource resource : this.customResources) {
            if (!resource.getJndiName().equals(this.refName)) continue;
            return true;
        }
        for (Resource resource : this.externalJndiResources) {
            if (!resource.getJndiName().equals(this.refName)) continue;
            return true;
        }
        for (Resource resource : this.jdbcResources) {
            if (!resource.getJndiName().equals(this.refName)) continue;
            return true;
        }
        for (Resource resource : this.mailResources) {
            if (!resource.getJndiName().equals(this.refName)) continue;
            return true;
        }
        for (Resource resource : this.persistenceMgrFactoryResources) {
            if (!resource.getJndiName().equals(this.refName)) continue;
            return true;
        }
        return false;
    }
}

