/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.connector.rmi;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.logging.Logger;

class RmiStubRegistryHandler {
    private final Logger logger;

    RmiStubRegistryHandler(int port, boolean secureRegistry, Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Internal: Null logger");
        }
        this.logger = logger;
        if (secureRegistry) {
            throw new UnsupportedOperationException("Yet to be implemented");
        }
        this.startInsecureRegistry(port);
    }

    private void startInsecureRegistry(int port) {
        try {
            Registry r = LocateRegistry.createRegistry(port);
            this.logBindings(r, port);
        }
        catch (Exception e) {
            throw new RuntimeException("Port " + port + " is not available for the internal rmi registry. " + "This means that a call was made with the same port, without closing earlier " + "registry instance. This has to do with the system jmx connector configuration " + "in admin-service element of the configuration associated with this instance");
        }
    }

    private void logBindings(Registry r, int port) {
        try {
            String[] bs = r.list();
            this.logger.info("Initial Bindings in RmiRegistry at port: [" + port + "] :" + (bs.length == 0 ? " NONE" : ""));
            for (int i = 0; i < bs.length; ++i) {
                this.logger.info("JMX Connector RMI Registry binding: " + bs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

