/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import org.glassfish.admin.connector.rmi.JmxConnectorServerDriver;
import org.glassfish.admin.connector.rmi.RemoteJmxProtocol;
import org.glassfish.admin.mbeanserver.ConnectorsStarter;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
@Async
public final class ConnectorStartupService
implements Startup,
PostConstruct {
    private volatile ConnectorsStarter mConnectorsStarter;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    AdminService mAdminService;

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    public ConnectorStartupService() {
        ConnectorStartupService.debug("ConnectorStartupService.ConnectorStartupService");
        this.mConnectorsStarter = null;
    }

    private static String toString(JmxConnector c) {
        return "JmxConnector config: { name = " + c.getName() + ", Protocol = " + c.getProtocol() + ", Address = " + c.getAddress() + ", Port = " + c.getPort() + ", AcceptAll = " + c.getAcceptAll() + ", AuthRealmName = " + c.getAuthRealmName() + ", SecurityEnabled = " + c.getSecurityEnabled() + "}";
    }

    private JMXConnectorServer startConnector(JmxConnector conn) throws IOException {
        String protocol = conn.getProtocol();
        String address = conn.getAddress();
        int port = Integer.parseInt(conn.getPort());
        String authRealmName = conn.getAuthRealmName();
        boolean securityEnabled = Boolean.parseBoolean(conn.getSecurityEnabled());
        ConnectorStartupService.debug(ConnectorStartupService.toString(conn));
        JmxConnectorServerDriver dr = new JmxConnectorServerDriver();
        dr.setMBeanServer(this.mMBeanServer);
        dr.setProtocol(RemoteJmxProtocol.instance(protocol));
        dr.setPort(port);
        dr.setSsl(securityEnabled);
        dr.setAuthentication(false);
        dr.setRmiRegistrySecureFlag(false);
        JMXConnectorServer server = dr.startConnectorServer();
        return server;
    }

    public void postConstruct() {
        if (this.mMBeanServer != ManagementFactory.getPlatformMBeanServer()) {
            throw new IllegalStateException("MBeanServer must be the Platform one");
        }
        List<JmxConnector> l = this.mAdminService.getJmxConnector();
        ConnectorStartupService.debug("SystemJmxConnectorName: " + this.mAdminService.getSystemJmxConnectorName() + ", " + l.size() + " connectors found");
        for (JmxConnector c : l) {
            if (!Boolean.parseBoolean(c.getEnabled())) {
                ConnectorStartupService.debug("JmxConnector " + c.getName() + " is disabled, skipping.");
                continue;
            }
            try {
                this.startConnector(c);
            }
            catch (Throwable t) {
                System.err.println("ERROR starting JMX connector: " + ConnectorStartupService.toString(c) + ": " + t);
            }
        }
        this.mConnectorsStarter = new ConnectorsStarter(this.mMBeanServer);
        new ConnectorsStarterThread(this.mConnectorsStarter).start();
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    private static final class ConnectorsStarterThread
    extends Thread {
        private final ConnectorsStarter mConnectorsStarter;

        public ConnectorsStarterThread(ConnectorsStarter cs) {
            this.mConnectorsStarter = cs;
        }

        public void run() {
            try {
                this.mConnectorsStarter.startConnectors();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

