/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.module.ModuleDefinition;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.server.ServerEnvironmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentContextImpl
implements DeploymentContext {
    final ReadableArchive source;
    final Properties parameters;
    final Logger logger;
    final ServerEnvironmentImpl env;
    ClassLoader cloader;
    Properties props;
    Map<String, Object> modulesMetaData = new HashMap<String, Object>();
    List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    List<ModuleDefinition> publicAPIs = new ArrayList<ModuleDefinition>();

    public DeploymentContextImpl(Logger logger, ReadableArchive source, Properties params, ServerEnvironmentImpl env) {
        this.source = source;
        this.logger = logger;
        this.parameters = params;
        this.env = env;
    }

    @Override
    public ReadableArchive getSource() {
        return this.source;
    }

    @Override
    public Properties getCommandParameters() {
        return this.parameters;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cloader;
    }

    public void setClassLoader(ClassLoader cloader) {
        this.cloader = cloader;
    }

    @Override
    public File getScratchDir(String subDirName) {
        String appName = this.parameters.getProperty("name");
        File rootScratchDir = this.env.getApplicationStubPath();
        if (subDirName != null) {
            rootScratchDir = new File(rootScratchDir, subDirName);
        }
        return new File(rootScratchDir, appName);
    }

    @Override
    public File getSourceDir() {
        return new File(this.source.getURI());
    }

    @Override
    public void addModuleMetaData(Object metaData) {
        this.modulesMetaData.put(metaData.getClass().getName(), metaData);
    }

    @Override
    public <T> T getModuleMetaData(Class<T> metadataType) {
        Object moduleMetaData = this.modulesMetaData.get(metadataType.getName());
        if (moduleMetaData != null) {
            return metadataType.cast(moduleMetaData);
        }
        return null;
    }

    @Override
    public Properties getProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public List<ClassFileTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    public void addPublicAPI(ModuleDefinition def) throws UnsupportedOperationException {
        this.publicAPIs.add(def);
    }

    public List<ModuleDefinition> getPublicAPIs() {
        return this.publicAPIs;
    }
}

