/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.flashlight.provider.Probe;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ProbeRegistry {
    private static ProbeRegistry _me = new ProbeRegistry();
    private ConcurrentHashMap<Integer, Probe> probeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Probe> probeDesc2ProbeMap = new ConcurrentHashMap();

    public static ProbeRegistry getInstance() {
        return _me;
    }

    public void registerProbe(Probe probe) {
        this.probeMap.put(probe.getId(), probe);
        this.probeDesc2ProbeMap.put(probe.getProbeStr(), probe);
        System.out.println("[FL]Registered probe : " + probe.getProbeStr());
    }

    public void unregisterProbe(Probe probe) {
        this.probeMap.remove(probe.getId());
    }

    public void unregisterProbe(int id) {
        this.probeMap.remove(id);
    }

    public Probe getProbe(int id) {
        return this.probeMap.get(id);
    }

    public Probe getProbe(String probeStr) {
        System.out.println("[FL]Get probe : " + probeStr);
        return this.probeDesc2ProbeMap.get(probeStr);
    }

    public static Probe getProbeById(int id) {
        return _me.getProbe(id);
    }
}

