/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.data.ContainerInfo;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ContainerRegistry {
    Map<String, ContainerInfo> containers = new HashMap<String, ContainerInfo>();

    public synchronized void addContainer(String name, ContainerInfo info) {
        this.containers.put(name, info);
        info.setRegistry(this);
    }

    public List<Sniffer> getStartedContainersSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (ContainerInfo info : this.getContainers()) {
            sniffers.add(info.getSniffer());
        }
        return sniffers;
    }

    public synchronized ContainerInfo getContainer(String containerType) {
        return this.containers.get(containerType);
    }

    public synchronized ContainerInfo removeContainer(ContainerInfo container) {
        for (Map.Entry<String, ContainerInfo> entry : this.containers.entrySet()) {
            if (!entry.getValue().equals(container)) continue;
            return this.containers.remove(entry.getKey());
        }
        return null;
    }

    public Iterable<ContainerInfo> getContainers() {
        ArrayList<ContainerInfo> copy = new ArrayList<ContainerInfo>(this.containers.size());
        copy.addAll(this.containers.values());
        return copy;
    }
}

