/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.Resource;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.NamingObjectsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class ResourcePropertiesHolder
implements NamingObjectsProvider,
ConfigListener {
    @Inject
    private Logger logger;
    @Inject
    private Habitat connectorRuntimeHabitat;
    protected Resource resource;
    protected ObservableBean propertyBean;
    private ConnectorRuntime runtime;

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ObservableBean getPropertyBean() {
        return this.propertyBean;
    }

    public void setPropertyBean(ObservableBean propertyBean) {
        this.propertyBean = propertyBean;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                NotProcessed np = null;
                switch (type) {
                    case ADD: {
                        ResourcePropertiesHolder.this.logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                        break;
                    }
                    case CHANGE: {
                        ResourcePropertiesHolder.this.logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        ResourcePropertiesHolder.this.logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        np = this.handleRemoveEvent(changedInstance);
                    }
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
                NotProcessed np = null;
                try {
                    Resource resource = ResourcePropertiesHolder.this.resource;
                    if (resource instanceof JdbcConnectionPool) {
                        JdbcConnectionPool pool = (JdbcConnectionPool)resource;
                        ResourcePropertiesHolder.this.getConnectorRuntime().redeployResource(pool);
                    } else if (resource instanceof ConnectorConnectionPool) {
                        ConnectorConnectionPool pool = (ConnectorConnectionPool)resource;
                        ResourcePropertiesHolder.this.getConnectorRuntime().redeployResource(pool);
                    } else {
                        np = new NotProcessed("Unknown resource type: " + resource);
                    }
                }
                catch (Exception ex) {
                    np = new NotProcessed(ex.toString());
                    Logger.getLogger(ResourcePropertiesHolder.class.getName()).log(Level.SEVERE, null, ex);
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
                NotProcessed np = null;
                try {
                    if (instance instanceof Property) {
                        Property prop = (Property)instance;
                        ObservableBean propertyBean = (ObservableBean)((Object)ConfigSupport.getImpl(prop));
                        ResourcePropertiesHolder.this.setPropertyBean(propertyBean);
                        ResourcePropertiesHolder.this.removeListener();
                    } else {
                        np = new NotProcessed("Unknown instance type (not a Property): " + instance);
                    }
                }
                catch (Exception ex) {
                    np = new NotProcessed(ex.toString());
                    Logger.getLogger(ResourcePropertiesHolder.class.getName()).log(Level.SEVERE, null, ex);
                }
                return np;
            }
        }, this.logger);
        return null;
    }

    void addListener() {
        this.propertyBean.addListener(this);
    }

    void removeListener() {
        this.propertyBean.removeListener(this);
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class, null);
        }
        return this.runtime;
    }
}

