/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.naming.NamingException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.persistence.jpa.JPAApplication;
import org.glassfish.persistence.jpa.JPAContainer;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JPADeployer
extends SimpleDeployer<JPAContainer, JPAApplication> {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ModulesRegistry modulesRegistry;

    @Override
    public MetaData getMetaData() {
        ArrayList<ModuleDefinition> modulesImportedForJPAApp = new ArrayList<ModuleDefinition>();
        modulesImportedForJPAApp.addAll(Arrays.asList(super.getMetaData().getPublicAPIs()));
        Iterable<Module> persistenceProviderModules = this.modulesRegistry.getModulesProvider(PersistenceProvider.class);
        for (Module persistenceProviderModule : persistenceProviderModules) {
            modulesImportedForJPAApp.add(persistenceProviderModule.getModuleDefinition());
        }
        return new MetaData(true, modulesImportedForJPAApp.toArray(new ModuleDefinition[modulesImportedForJPAApp.size()]), null, new Class[]{Application.class});
    }

    @Override
    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    @Override
    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    @Override
    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    @Override
    public boolean prepare(DeploymentContext context) {
        boolean prepared = super.prepare(context);
        if (prepared) {
            Application application = context.getModuleMetaData(Application.class);
            Set<BundleDescriptor> bundles = application.getBundleDescriptors();
            ArrayList<PersistenceUnitDescriptor> allReferencedPus = new ArrayList<PersistenceUnitDescriptor>();
            for (BundleDescriptor bundle : bundles) {
                allReferencedPus.addAll(bundle.findReferencedPUs());
            }
            JPAApplication jpaApp = new JPAApplication(allReferencedPus, new ProviderContainerContractInfoImpl(context, this.connectorRuntime));
            context.addModuleMetaData(jpaApp);
        }
        return prepared;
    }

    @Override
    public JPAApplication load(JPAContainer container, DeploymentContext context) {
        return context.getModuleMetaData(JPAApplication.class);
    }

    private static class ProviderContainerContractInfoImpl
    implements ProviderContainerContractInfo {
        private DeploymentContext deploymentContext;
        private ConnectorRuntime connectorRuntime;

        public ProviderContainerContractInfoImpl(DeploymentContext deploymentContext, ConnectorRuntime connectorRuntime) {
            this.deploymentContext = deploymentContext;
            this.connectorRuntime = connectorRuntime;
        }

        public ClassLoader getClassLoader() {
            return this.deploymentContext.getClassLoader();
        }

        public ClassLoader getTempClassloader() {
            return ((InstrumentableClassLoader)((Object)this.deploymentContext.getClassLoader())).copy();
        }

        public void addTransformer(final ClassTransformer transformer) {
            this.deploymentContext.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                }
            });
        }

        public String getApplicationLocation() {
            return this.deploymentContext.getSourceDir().getAbsolutePath();
        }

        public DataSource lookupDataSource(String dataSourceName) throws NamingException {
            return (DataSource)DataSource.class.cast(this.connectorRuntime.lookupPMResource(dataSourceName, false));
        }

        public DataSource lookupNonTxDataSource(String dataSourceName) throws NamingException {
            return (DataSource)DataSource.class.cast(this.connectorRuntime.lookupNonTxResource(dataSourceName, false));
        }
    }
}

