/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.rails;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.ApplicationContainer;

public class RailsApplication
implements ApplicationContainer,
org.glassfish.api.container.Adapter {
    private final Logger logger;
    private Object jRubyRuntime;
    private Adapter adapter;
    private final String contextRoot;
    private final JRubyEnvironment jrubyEnv;
    private final ServerEnvironment env;

    RailsApplication(ServerEnvironment env, String railsRoot, Logger logger, String ctxRoot) {
        this.logger = logger;
        this.jrubyEnv = new JRubyEnvironment(env.getStartupContext());
        this.env = env;
        this.contextRoot = ctxRoot;
        try {
            URL[] urls = this.findJRubyJars();
            JRubyRailsClassLoader cl = new JRubyRailsClassLoader(urls, RailsApplication.class.getClassLoader());
            Class<?> c = ((ClassLoader)cl).loadClass("com.sun.grizzly.jruby.RubyRuntime");
            this.jRubyRuntime = c.getConstructor(String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE).newInstance(this.contextRoot, railsRoot, this.jrubyEnv.jrubyLib, this.jrubyEnv.numberOfRuntime, true);
            this.adapter = (Adapter)c.getMethod("getAdapter", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating RailsAdapter: " + e.getMessage(), e);
            return;
        }
    }

    public boolean start(ClassLoader cl) {
        return true;
    }

    public boolean stop() {
        try {
            this.jRubyRuntime.getClass().getMethod("stopRubyRuntimePool", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error stopping application : " + this.contextRoot + ". " + e.getMessage(), e);
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public Object getDescriptor() {
        return null;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void service(Request request, Response response) throws Exception {
        this.adapter.service(request, response);
    }

    public void afterService(Request request, Response response) throws Exception {
        this.adapter.afterService(request, response);
    }

    public void fireAdapterEvent(String s, Object o) {
        this.adapter.fireAdapterEvent(s, o);
    }

    private URL[] findJRubyJars() throws MalformedURLException, ClassNotFoundException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File jrubyLibDir = new File(this.jrubyEnv.jrubyLib);
        File jrubyJar = new File(this.jrubyEnv.jrubyLib, "jruby.jar");
        if (!jrubyJar.exists()) {
            throw new IllegalArgumentException("jruby.jar at: " + this.jrubyEnv.jrubyLib + " not found.");
        }
        for (File lib : jrubyLibDir.listFiles()) {
            if (!lib.isFile() || !lib.toString().endsWith(".jar")) continue;
            urls.add(lib.toURI().toURL());
        }
        File grizzlyjruby = this.env.getStartupContext().getRootDirectory();
        File[] grizzlyjrubyJars = grizzlyjruby.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith("grizzly-jruby-module") && name.startsWith("grizzly-jruby");
            }
        });
        if (grizzlyjrubyJars.length > 0) {
            urls.add(grizzlyjrubyJars[0].toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private final class JRubyEnvironment {
        final String jrubyHome = System.getProperty("jruby.home");
        final int numberOfRuntime;
        final String jrubyLib;
        private final String jrubyRuntime = System.getProperty("jruby.runtime");
        private final String railsEnv = System.getProperty("RAILS_ENV");

        public JRubyEnvironment(StartupContext startupContext) {
            if (this.jrubyHome == null) {
                RailsApplication.this.logger.severe("jruby.home cannot be null");
                throw new IllegalArgumentException("jruby.home cannot be null");
            }
            int numRt = 1;
            if (this.jrubyRuntime != null) {
                try {
                    numRt = Integer.parseInt(this.jrubyRuntime);
                }
                catch (NumberFormatException ex) {
                    RailsApplication.this.logger.log(Level.WARNING, "Invalid number of Runtimes specified.");
                }
            } else if (this.railsEnv != null && this.railsEnv.equalsIgnoreCase("production")) {
                numRt = 3;
            }
            if (startupContext.getArguments().get("--runtimes") != null) {
                try {
                    numRt = Integer.parseInt(startupContext.getArguments().get("--runtimes"));
                }
                catch (NumberFormatException ex) {
                    RailsApplication.this.logger.log(Level.WARNING, "Invalid number of Runtimes specified.");
                }
            }
            this.numberOfRuntime = numRt;
            this.jrubyLib = this.jrubyHome + "/lib";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JRubyRailsClassLoader
    extends URLClassLoader {
        private final ClassLoader parent;

        public JRubyRailsClassLoader(URL[] urls, ClassLoader parent) {
            super(urls);
            this.parent = parent;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> c;
            try {
                c = this.parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name);
            }
            return c;
        }
    }
}

