/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.admingui.handlers;

import com.sun.appserv.management.ext.realm.RealmsMgr;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.GuiUtil;

public class FileUserHandler {
    public static void saveUser(HandlerContext handlerCtx) {
        try {
            RealmsMgr realmsMgr = AMXRoot.getInstance().getRealmsMgr();
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray(grouplist, ",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            realmsMgr.updateUser(realmName, userid, userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void addUser(HandlerContext handlerCtx) {
        try {
            RealmsMgr realmsMgr = AMXRoot.getInstance().getRealmsMgr();
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray(grouplist, ",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            realmsMgr.addUser(realmName, userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getUserInfo(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String userName = (String)handlerCtx.getInputValue("User");
        handlerCtx.setOutputValue("GroupList", FileUserHandler.getGroupNames(realmName, userName));
    }

    public static void getFileUsers(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        ArrayList result = new ArrayList();
        try {
            RealmsMgr realmsMgr = AMXRoot.getInstance().getRealmsMgr();
            String[] userNames = realmsMgr.getUserNames(realmName);
            if (userNames != null) {
                HashMap<String, Object> map = null;
                for (int i = 0; i < userNames.length; ++i) {
                    map = new HashMap<String, Object>();
                    map.put("users", userNames[i]);
                    map.put("groups", FileUserHandler.getGroupNames(realmName, userNames[i]));
                    map.put("selected", false);
                    result.add(map);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void removeUser(HandlerContext handlerCtx) {
        RealmsMgr realmsMgr = AMXRoot.getInstance().getRealmsMgr();
        String realmName = (String)handlerCtx.getInputValue("Realm");
        try {
            List obj;
            List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
            for (Map oneRow : selectedRows) {
                String user = (String)oneRow.get("users");
                realmsMgr.removeUser(realmName, user);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void hasManageUserButton(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("realmName");
        RealmsMgr realmsMgr = AMXRoot.getInstance().getRealmsMgr();
        handlerCtx.setOutputValue("result", realmsMgr.supportsUserManagement(realmName));
    }

    private static String getGroupNames(String realmName, String userName) {
        try {
            RealmsMgr realmsMgr = AMXRoot.getInstance().getRealmsMgr();
            return GuiUtil.arrayToString(realmsMgr.getGroupNames(realmName, userName), ",");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }
}

