/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.statistics;

import java.lang.management.MemoryUsage;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Statistic;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.MethodInvoker;
import org.glassfish.flashlight.datatree.TreeNode;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class JVMStatsImpl
implements MonitorContract {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    Logger logger;
    private final String name = "jvm";
    private final String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s";

    public String getName() {
        return "jvm";
    }

    public ActionReport process(ActionReport report, String filter) {
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("MonitoringRuntimeDataRegistry is null");
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("MonitoringRuntimeDataRegistry server node is null");
            return report;
        }
        long init = 0L;
        long used = 0L;
        long committed = 0L;
        long max = 0L;
        MethodInvoker tn = (MethodInvoker)serverNode.getNode("jvm").getNode("committedHeapSize");
        this.logger.finest("JVMStatsImpl: tn name = " + tn.getName());
        this.logger.finest("JVMStatsImpl: tn class name = " + tn.getClass().getName());
        this.logger.finest("JVMStatsImpl: tn value = " + tn.getValue());
        this.logger.finest("JVMStatsImpl: tn value class name = " + tn.getValue().getClass().getName());
        this.logger.finest("JVMStatsImpl: tn instance = " + tn.getInstance());
        this.logger.finest("JVMStatsImpl: tn instance class name = " + tn.getInstance().getClass().getName());
        MemoryUsage mu = (MemoryUsage)tn.getInstance();
        report.setMessage(String.format("%1$-10s %2$-10s %3$-10s %4$-10s", mu.getInit(), mu.getUsed(), mu.getCommitted(), mu.getMax()));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    public Statistic[] getStatistics() {
        return null;
    }

    public String[] getStatisticNames() {
        return null;
    }

    public Statistic getStatistic(String statisticName) {
        return null;
    }
}

