/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

public class JVMMemoryStatsTelemetry {
    private TreeNode jvmNode;
    private MemoryUsage heapUsage;
    private MemoryUsage nonheapUsage;
    private MemoryMXBean bean;
    private static final String BYTE_UNITS = "monitor.stats.byte_units";
    private static final StringManager localStrMgr = StringManager.getManager(JVMMemoryStatsTelemetry.class);
    private Counter commitHeapSize = CounterFactory.createCount(new long[0]);
    private boolean jvmMonitoringEnabled;
    private Logger logger;

    public JVMMemoryStatsTelemetry(TreeNode server, boolean jvmMonitoringEnabled, Logger logger) {
        try {
            this.logger = logger;
            this.jvmNode = TreeNodeFactory.createTreeNode("jvm", null, "jvm");
            server.addChild(this.jvmNode);
            this.bean = ManagementFactory.getMemoryMXBean();
            this.heapUsage = this.bean.getHeapMemoryUsage();
            this.nonheapUsage = this.bean.getNonHeapMemoryUsage();
            Method m = this.heapUsage.getClass().getMethod("getCommitted", null);
            logger.finest("heapUsage.getCommitted() = " + this.heapUsage.getCommitted());
            logger.finest("Method m.invoke() = " + m.invoke((Object)this.heapUsage, (Object[])null));
            TreeNode committedHeapSize = TreeNodeFactory.createMethodInvoker("committedHeapSize", this.heapUsage, "jvm", m);
            this.jvmNode.addChild(committedHeapSize);
            this.jvmNode.setEnabled(jvmMonitoringEnabled);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JVMMemoryStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(JVMMemoryStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(JVMMemoryStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(JVMMemoryStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(JVMMemoryStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void enableMonitoring(boolean isEnabled) {
        if (isEnabled != this.jvmMonitoringEnabled) {
            this.jvmMonitoringEnabled = isEnabled;
            this.jvmNode.setEnabled(this.jvmMonitoringEnabled);
        }
    }

    public Counter getCommittedHeapSize() {
        this.commitHeapSize.setCount(this.heapUsage.getCommitted());
        return this.commitHeapSize;
    }
}

