/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.util.Collection;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;
import org.glassfish.web.admin.monitor.telemetry.WebMonitorStartup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspStatsTelemetry {
    private Collection<ProbeClientMethodHandle> handles;
    private boolean webMonitoringEnabled;
    private String moduleName;
    private String vsName;
    private Logger logger;
    private Counter activeJspsLoadedCount = CounterFactory.createCount(new long[0]);
    private Counter maxJspsLoadedCount = CounterFactory.createCount(new long[0]);
    private Counter totalJspsLoadedCount = CounterFactory.createCount(new long[0]);

    public JspStatsTelemetry(TreeNode parent, String moduleName, String vsName, boolean webMonitoringEnabled, Logger logger) {
        this.logger = logger;
        this.moduleName = moduleName;
        this.vsName = vsName;
        this.activeJspsLoadedCount.setName("activeJspsLoadedCount");
        parent.addChild(this.activeJspsLoadedCount);
        this.maxJspsLoadedCount.setName("maxJspsLoadedCount");
        parent.addChild(this.maxJspsLoadedCount);
        this.totalJspsLoadedCount.setName("totalJspsLoadedCount");
        parent.addChild(this.totalJspsLoadedCount);
        this.webMonitoringEnabled = webMonitoringEnabled;
    }

    public void enableMonitoring(boolean isEnable) {
    }

    public void enableMonitoringForSubElements(boolean isEnable) {
    }

    @ProbeListener(value="web:jsp::jspLoadedEvent")
    public void jspLoadedEvent(@ProbeParam(value="jsp") Servlet jsp, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("Servlet Loaded event received - jspName = " + jsp.getServletConfig().getServletName() + ": appName = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeJspsLoadedCount.increment();
        this.totalJspsLoadedCount.increment();
        if (this.activeJspsLoadedCount.getCount() > this.maxJspsLoadedCount.getCount()) {
            this.maxJspsLoadedCount.setCount(this.activeJspsLoadedCount.getCount());
        }
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
        if (!this.webMonitoringEnabled) {
            this.tuneProbeListenerHandles(this.webMonitoringEnabled);
        }
    }

    public void enableProbeListenerHandles(boolean isEnabled) {
        if (isEnabled != this.webMonitoringEnabled) {
            this.webMonitoringEnabled = isEnabled;
            this.tuneProbeListenerHandles(this.webMonitoringEnabled);
        }
    }

    private void tuneProbeListenerHandles(boolean shouldEnable) {
        for (ProbeClientMethodHandle handle : this.handles) {
            if (shouldEnable) {
                handle.enable();
                continue;
            }
            handle.disable();
        }
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        String appName = WebMonitorStartup.getAppName(mName);
        return this.moduleName.equals(appName) && this.vsName.equals(hostName);
    }
}

