/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.util.Collection;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;
import org.glassfish.web.admin.monitor.telemetry.WebMonitorStartup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionStatsTelemetry {
    private String moduleName;
    private String vsName;
    private TreeNode sessionTM;
    private TreeNode[] sessionChildren;
    private Logger logger;
    private Collection<ProbeClientMethodHandle> handles;
    private boolean webMonitoringEnabled;
    private Counter activeSessionsCurrent = CounterFactory.createCount(new long[0]);
    private Counter activeSessionsHigh = CounterFactory.createCount(new long[0]);
    private Counter sessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter expiredSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter rejectedSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter persistedSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter passivatedSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter activatedSessionsTotal = CounterFactory.createCount(new long[0]);

    public SessionStatsTelemetry(TreeNode parent, String moduleName, String vsName, boolean webMonitoringEnabled, Logger logger) {
        this.logger = logger;
        this.moduleName = moduleName;
        this.vsName = vsName;
        this.webMonitoringEnabled = webMonitoringEnabled;
        this.activeSessionsCurrent.setName("activeSessionsCurrent");
        parent.addChild(this.activeSessionsCurrent);
        this.sessionsTotal.setName("sessionsTotal");
        parent.addChild(this.sessionsTotal);
        this.activeSessionsHigh.setName("activeSessionsHigh");
        parent.addChild(this.activeSessionsHigh);
        this.rejectedSessionsTotal.setName("rejectedSessionsTotal");
        parent.addChild(this.rejectedSessionsTotal);
        this.expiredSessionsTotal.setName("expiredSessionsTotal");
        parent.addChild(this.expiredSessionsTotal);
        this.persistedSessionsTotal.setName("persistedSessionsTotal");
        parent.addChild(this.persistedSessionsTotal);
        this.passivatedSessionsTotal.setName("passivatedSessionsTotal");
        parent.addChild(this.passivatedSessionsTotal);
        this.activatedSessionsTotal.setName("activatedSessionsTotal");
        parent.addChild(this.activatedSessionsTotal);
    }

    public void enableMonitoring(boolean isEnable) {
    }

    public void enableMonitoringForSubElements(boolean isEnable) {
    }

    @ProbeListener(value="web:session::sessionCreatedEvent")
    public void sessionCreatedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionCreatedEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.sessionsTotal.increment();
        this.incrementActiveSessionsCurrent();
    }

    @ProbeListener(value="web:session::sessionDestroyedEvent")
    public void sessionDestroyedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionDestroyedEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeSessionsCurrent.decrement();
    }

    @ProbeListener(value="web:session::sessionRejectedEvent")
    public void sessionRejectedEvent(@ProbeParam(value="maxThresholdSize") int maxSessions, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionRejectedEvent received - max sessions = " + maxSessions + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeSessionsCurrent.decrement();
        this.rejectedSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionExpiredEvent")
    public void sessionExpiredEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionExpiredEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeSessionsCurrent.decrement();
        this.expiredSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionPersistedStartEvent")
    public void sessionPersistedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPersistedStartEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="web:session::sessionPersistedEndEvent")
    public void sessionPersistedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPersistedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeSessionsCurrent.decrement();
        this.persistedSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionActivatedStartEvent")
    public void sessionActivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionActivatedStartEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="web:session::sessionActivatedEndEvent")
    public void sessionActivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionActivatedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.incrementActiveSessionsCurrent();
        this.activatedSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionPassivatedStartEvent")
    public void sessionPassivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPassivatedStartEvent  received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="web:session::sessionPassivatedEndEvent")
    public void sessionPassivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPassivatedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeSessionsCurrent.decrement();
        this.passivatedSessionsTotal.increment();
    }

    private void incrementActiveSessionsCurrent() {
        this.activeSessionsCurrent.increment();
        if (this.activeSessionsCurrent.getCount() > this.activeSessionsHigh.getCount()) {
            this.activeSessionsHigh.setCount(this.activeSessionsCurrent.getCount());
        }
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
        if (!this.webMonitoringEnabled) {
            this.tuneProbeListenerHandles(this.webMonitoringEnabled);
        }
    }

    public void enableProbeListenerHandles(boolean isEnabled) {
        if (isEnabled != this.webMonitoringEnabled) {
            this.webMonitoringEnabled = isEnabled;
            this.tuneProbeListenerHandles(this.webMonitoringEnabled);
        }
    }

    private void tuneProbeListenerHandles(boolean shouldEnable) {
        for (ProbeClientMethodHandle handle : this.handles) {
            if (shouldEnable) {
                handle.enable();
                continue;
            }
            handle.disable();
        }
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        String appName = WebMonitorStartup.getAppName(mName);
        return this.moduleName.equals(appName) && this.vsName.equals(hostName);
    }
}

