/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.util.Collection;
import java.util.logging.Logger;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.provider.annotations.ProbeParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolTelemetry {
    private TreeNode threadpoolNode;
    private Collection<ProbeClientMethodHandle> handles;
    private boolean threadpoolMonitoringEnabled;
    private Logger logger;

    public ThreadPoolTelemetry(TreeNode parent, boolean threadpoolMonitoringEnabled, Logger logger) {
        this.logger = logger;
        this.threadpoolMonitoringEnabled = threadpoolMonitoringEnabled;
    }

    @ProbeListener(value="core:threadpool::newThreadsAllocatedEvent")
    public void newThreadsAllocatedEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="increment") int increment, @ProbeParam(value="boolean") boolean startThread) {
        this.logger.finest("[TM]newThreadsAllocatedEvent received - : increment = " + increment + " :startThread = " + startThread + ": Thread pool name = " + threadPoolName);
    }

    @ProbeListener(value="core:threadpool::maxNumberOfThreadsReachedEvent")
    public void maxNumberOfThreadsReachedEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="maxNumberOfThreads") int maxNumberOfThreads) {
        this.logger.finest("[TM]maxNumberOfThreadsReachedEvent received - : maxNumberOfThreads = " + maxNumberOfThreads + ": Thread pool name = " + threadPoolName);
    }

    @ProbeListener(value="core:threadpool::threadDispatchedFromPoolEvent")
    public void threadDispatchedFromPoolEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") String threadId) {
        this.logger.finest("[TM]threadDispatchedFromPoolEvent received - : threadId = " + threadId + ": Thread pool name = " + threadPoolName);
    }

    @ProbeListener(value="core:threadpool::threadReturnedToPoolEvent")
    public void threadReturnedToPoolEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") String threadId) {
        this.logger.finest("[TM]threadReturnedToPoolEvent received - : threadId = " + threadId + ": Thread pool name = " + threadPoolName);
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
        if (!this.threadpoolMonitoringEnabled) {
            this.tuneProbeListenerHandles(this.threadpoolMonitoringEnabled);
        }
    }

    public void enableProbeListenerHandles(boolean isEnabled) {
        if (isEnabled != this.threadpoolMonitoringEnabled) {
            this.threadpoolMonitoringEnabled = isEnabled;
            this.tuneProbeListenerHandles(this.threadpoolMonitoringEnabled);
        }
    }

    private void tuneProbeListenerHandles(boolean shouldEnable) {
        for (ProbeClientMethodHandle handle : this.handles) {
            if (shouldEnable) {
                handle.enable();
                continue;
            }
            handle.disable();
        }
    }

    public void enableMonitoring(boolean isEnable) {
    }

    public void enableMonitoringForSubElements(boolean isEnable) {
    }
}

