/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.config.serverbeans.WebModule;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderListener;
import org.glassfish.web.admin.monitor.telemetry.JVMMemoryStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.JspStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.ServletStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.SessionStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.ThreadPoolTelemetry;
import org.glassfish.web.admin.monitor.telemetry.WebModuleTelemetry;
import org.glassfish.web.admin.monitor.telemetry.WebRequestTelemetry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class WebMonitorStartup
implements Startup,
PostConstruct,
ProbeProviderListener,
ConfigListener {
    private boolean threadpoolMonitoringEnabled = true;
    private boolean httpServiceMonitoringEnabled = true;
    private boolean jvmMonitoringEnabled = true;
    private boolean webMonitoringEnabled = true;
    @Inject
    private ProbeProviderEventManager ppem;
    @Inject
    private ProbeClientMediator pcm;
    @Inject
    private ModuleMonitoringLevels mml;
    @Inject
    Logger logger;
    private WebRequestTelemetry webRequestTM = null;
    private WebModuleTelemetry moduleTM = null;
    private SessionStatsTelemetry webSessionsTM = null;
    private List<SessionStatsTelemetry> vsSessionTMs = null;
    private ServletStatsTelemetry webServletsTM = null;
    private List<ServletStatsTelemetry> vsServletTMs = null;
    private JspStatsTelemetry webJspTM = null;
    private List<JspStatsTelemetry> vsJspTMs = null;
    private ThreadPoolTelemetry threadPoolTM = null;
    private JVMMemoryStatsTelemetry jvmMemoryTM = null;
    @Inject
    private static Domain domain;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    private TreeNode serverNode;
    private TreeNode httpServiceNode;
    private TreeNode webNode;
    private TreeNode webSessionNode;
    private TreeNode webServletNode;
    private TreeNode webJspNode;
    private TreeNode webRequestNode;
    private Level dbgLevel = Level.FINEST;
    private Level defaultLevel;

    public void postConstruct() {
        this.logger.finest("In the Web Monitor startup ************");
        this.logger.finest("In the Web Monitor startup ************");
        this.buildWebMonitoringConfigTree();
        this.ppem.registerProbeProviderListener(this);
        this.jvmMemoryTM = new JVMMemoryStatsTelemetry(this.serverNode, this.jvmMonitoringEnabled, this.logger);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void providerRegistered(String moduleName, String providerName, String appName) {
        try {
            Collection<TreeNode> vsNodes;
            Collection<TreeNode> appNodes;
            TreeNode appsNode;
            Collection<ProbeClientMethodHandle> handles;
            this.logger.finest("Provider registered event received - providerName = " + providerName + " : module name = " + moduleName + " : appName = " + appName);
            if (providerName.equals("session")) {
                this.logger.finest("and it is Web session");
                if (this.webSessionsTM == null) {
                    this.webSessionsTM = new SessionStatsTelemetry(this.webSessionNode, null, null, this.webMonitoringEnabled, this.logger);
                    handles = this.pcm.registerListener(this.webSessionsTM);
                    this.webSessionsTM.setProbeListenerHandles(handles);
                }
                if (this.vsSessionTMs == null) {
                    this.vsSessionTMs = new ArrayList<SessionStatsTelemetry>();
                    appsNode = this.serverNode.getNode("applications");
                    appNodes = appsNode.getChildNodes();
                    for (TreeNode appNode : appNodes) {
                        vsNodes = appNode.getChildNodes();
                        for (TreeNode vsNode : vsNodes) {
                            SessionStatsTelemetry vsSessionTM = new SessionStatsTelemetry(vsNode, appNode.getName(), vsNode.getName(), this.webMonitoringEnabled, this.logger);
                            this.vsSessionTMs.add(vsSessionTM);
                        }
                    }
                }
            }
            if (providerName.equals("servlet")) {
                this.logger.finest("and it is Web servlet");
                if (this.webServletsTM == null) {
                    this.webServletsTM = new ServletStatsTelemetry(this.webServletNode, null, null, this.webMonitoringEnabled, this.logger);
                    handles = this.pcm.registerListener(this.webServletsTM);
                    this.webServletsTM.setProbeListenerHandles(handles);
                }
                if (this.vsServletTMs == null) {
                    this.vsServletTMs = new ArrayList<ServletStatsTelemetry>();
                    appsNode = this.serverNode.getNode("applications");
                    appNodes = appsNode.getChildNodes();
                    for (TreeNode appNode : appNodes) {
                        vsNodes = appNode.getChildNodes();
                        for (TreeNode vsNode : vsNodes) {
                            ServletStatsTelemetry vsServletTM = new ServletStatsTelemetry(vsNode, appNode.getName(), vsNode.getName(), this.webMonitoringEnabled, this.logger);
                            this.vsServletTMs.add(vsServletTM);
                        }
                    }
                }
            }
            if (providerName.equals("jsp")) {
                this.logger.finest("and it is Web jsp");
                if (this.webJspTM == null) {
                    this.webJspTM = new JspStatsTelemetry(this.webJspNode, null, null, this.webMonitoringEnabled, this.logger);
                    handles = this.pcm.registerListener(this.webJspTM);
                    this.webJspTM.setProbeListenerHandles(handles);
                }
                if (this.vsJspTMs == null) {
                    this.vsJspTMs = new ArrayList<JspStatsTelemetry>();
                    appsNode = this.serverNode.getNode("applications");
                    appNodes = appsNode.getChildNodes();
                    for (TreeNode appNode : appNodes) {
                        vsNodes = appNode.getChildNodes();
                        for (TreeNode vsNode : vsNodes) {
                            JspStatsTelemetry vsJspTM = new JspStatsTelemetry(vsNode, appNode.getName(), vsNode.getName(), this.webMonitoringEnabled, this.logger);
                            this.vsJspTMs.add(vsJspTM);
                        }
                    }
                }
            }
            if (providerName.equals("request")) {
                this.logger.finest("and it is Web request");
                if (this.webRequestTM == null) {
                    this.webRequestTM = new WebRequestTelemetry(this.webRequestNode, this.webMonitoringEnabled, this.logger);
                    handles = this.pcm.registerListener(this.webRequestTM);
                    this.webRequestTM.setProbeListenerHandles(handles);
                }
            }
            if (providerName.equals("threadpool")) {
                this.logger.finest("and it is threadpool");
                if (this.threadPoolTM == null) {
                    this.threadPoolTM = new ThreadPoolTelemetry(this.httpServiceNode, this.threadpoolMonitoringEnabled, this.logger);
                    handles = this.pcm.registerListener(this.threadPoolTM);
                    this.threadPoolTM.setProbeListenerHandles(handles);
                }
            }
        }
        catch (Exception e) {
            this.logger.finest("WARNING: Exception in WebMonitorStartup : " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void providerUnregistered(String moduleName, String providerName, String appName) {
    }

    private void buildWebMonitoringConfigTree() {
        Server srvr = null;
        List<Server> ls = domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        this.serverNode = TreeNodeFactory.createTreeNode("server", null, "server");
        this.mrdr.add("server", this.serverNode);
        this.webNode = TreeNodeFactory.createTreeNode("web", null, "web");
        this.serverNode.addChild(this.webNode);
        this.webSessionNode = TreeNodeFactory.createTreeNode("session", null, "web");
        this.webNode.addChild(this.webSessionNode);
        this.webServletNode = TreeNodeFactory.createTreeNode("servlet", null, "web");
        this.webNode.addChild(this.webServletNode);
        this.webJspNode = TreeNodeFactory.createTreeNode("jsp", null, "web");
        this.webNode.addChild(this.webJspNode);
        this.webRequestNode = TreeNodeFactory.createTreeNode("request", this, "web");
        this.webNode.addChild(this.webRequestNode);
        TreeNode applications = TreeNodeFactory.createTreeNode("applications", null, "web");
        this.serverNode.addChild(applications);
        List<Application> la = domain.getApplications().getModules(Application.class);
        for (Application sapp : la) {
            TreeNode app = TreeNodeFactory.createTreeNode(sapp.getName(), null, "web");
            applications.addChild(app);
            this.addVirtualServers(srvr, app, sapp.getName());
        }
        List<J2eeApplication> lja = domain.getApplications().getModules(J2eeApplication.class);
        for (J2eeApplication japp : lja) {
            TreeNode app = TreeNodeFactory.createTreeNode(japp.getName(), null, "web");
            applications.addChild(app);
        }
        List<WebModule> lm = domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            TreeNode app = TreeNodeFactory.createTreeNode(wm.getName(), null, "web");
            applications.addChild(app);
            this.addVirtualServers(srvr, app, wm.getName());
        }
        Config sConfig = null;
        List<Config> lcfg = domain.getConfigs().getConfig();
        for (Config cfg : lcfg) {
            if (!"server-config".equals(cfg.getName())) continue;
            sConfig = cfg;
            break;
        }
        HttpService httpS = sConfig.getHttpService();
        this.httpServiceNode = TreeNodeFactory.createTreeNode("http-service", null, "web");
        this.serverNode.addChild(this.httpServiceNode);
        for (VirtualServer vServer : httpS.getVirtualServer()) {
            TreeNode vs = TreeNodeFactory.createTreeNode(vServer.getId(), null, "web");
            this.httpServiceNode.addChild(vs);
            String httpL = vServer.getHttpListeners();
            if (httpL == null) continue;
            for (String str : httpL.split(",")) {
                TreeNode httpListener = TreeNodeFactory.createTreeNode(str, null, "web");
                vs.addChild(httpListener);
            }
        }
        for (HttpListener htl : httpS.getHttpListener()) {
            TreeNode httpListener = TreeNodeFactory.createTreeNode(htl.getId(), null, "web");
            this.httpServiceNode.addChild(httpListener);
        }
        ConnectionPool cp = httpS.getConnectionPool();
        TreeNode connectionPool = TreeNodeFactory.createTreeNode("connection-pool", null, "web");
        this.httpServiceNode.addChild(connectionPool);
        WebContainer wc = sConfig.getWebContainer();
        TreeNode webContainer = TreeNodeFactory.createTreeNode("web-container", null, "web");
        this.serverNode.addChild(webContainer);
        ThreadPools tps = sConfig.getThreadPools();
        TreeNode threadPools = TreeNodeFactory.createTreeNode("thread-pools", null, "web");
        this.serverNode.addChild(threadPools);
    }

    private void addVirtualServers(Server server, TreeNode tn, String appName) {
        for (ApplicationRef ar : server.getApplicationRef()) {
            if (!appName.equals(ar.getRef())) continue;
            String vsL = ar.getVirtualServers();
            if (vsL != null) {
                for (String str : vsL.split(",")) {
                    TreeNode vs = TreeNodeFactory.createTreeNode(str, null, "web");
                    tn.addChild(vs);
                }
            } else {
                TreeNode vs = TreeNodeFactory.createTreeNode("server", null, "web");
                tn.addChild(vs);
            }
            return;
        }
    }

    public static String getAppName(String contextRoot) {
        List<WebModule> lm = domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            if (!contextRoot.equals(wm.getContextRoot())) continue;
            return wm.getName();
        }
        List<Application> la = domain.getApplications().getModules(Application.class);
        for (Application sapp : la) {
            if (!contextRoot.equals(sapp.getContextRoot())) continue;
            return sapp.getName();
        }
        return null;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            boolean enabled;
            String propName = event.getPropertyName();
            String mLevel = null;
            if ("http-service".equals(propName)) {
                this.mml = (ModuleMonitoringLevels)event.getSource();
                mLevel = event.getNewValue().toString();
                enabled = this.getEnabledValue(mLevel);
                this.logger.finest("[TM] Config change event - propName = " + propName + " : enabled=" + enabled);
                continue;
            }
            if ("jvm".equals(propName)) {
                this.mml = (ModuleMonitoringLevels)event.getSource();
                mLevel = event.getNewValue().toString();
                enabled = this.getEnabledValue(mLevel);
                this.logger.finest("[TM] Config change event - propName = " + propName + " : enabled=" + enabled);
                continue;
            }
            if ("thread-pool".equals(propName)) {
                this.mml = (ModuleMonitoringLevels)event.getSource();
                mLevel = event.getNewValue().toString();
                enabled = this.getEnabledValue(mLevel);
                this.logger.finest("[TM] Config change event - propName = " + propName + " : enabled=" + enabled);
                continue;
            }
            if (!"web-container".equals(propName)) continue;
            this.mml = (ModuleMonitoringLevels)event.getSource();
            mLevel = event.getNewValue().toString();
            enabled = this.getEnabledValue(mLevel);
            this.logger.finest("[TM] Config change event - propName = " + propName + " : enabled=" + enabled);
        }
        return null;
    }

    private boolean getEnabledValue(String enabledStr) {
        return !"OFF".equals(enabledStr);
    }
}

