/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.CounterFactory;
import org.glassfish.flashlight.statistics.factory.TimeStatsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRequestTelemetry {
    private Counter errorCount = CounterFactory.createCount(new long[0]);
    private TimeStats requestProcessTime = TimeStatsFactory.createTimeStatsMilli();
    private Collection<ProbeClientMethodHandle> handles;
    private boolean webMonitoringEnabled;
    private Logger logger;
    ThreadLocal<Long> entry = new ThreadLocal();

    public WebRequestTelemetry(TreeNode parent, boolean webMonitoringEnabled, Logger logger) {
        try {
            this.logger = logger;
            this.webMonitoringEnabled = webMonitoringEnabled;
            Method m1 = this.requestProcessTime.getClass().getMethod("getMaximumTime", null);
            TreeNode maxTime = TreeNodeFactory.createMethodInvoker("maxTime", this.requestProcessTime, "request", m1);
            parent.addChild(maxTime);
            this.requestProcessTime.getCount();
            Method m2 = this.requestProcessTime.getClass().getMethod("getCount", null);
            TreeNode requestCount = TreeNodeFactory.createMethodInvoker("requestCount", this.requestProcessTime, "request", m2);
            parent.addChild(requestCount);
            Method m3 = this.getClass().getMethod("getProcessTime", null);
            TreeNode processingTime = TreeNodeFactory.createMethodInvoker("processingTime", this, "request", m3);
            parent.addChild(processingTime);
            this.errorCount.setName("errorCount");
            parent.addChild(this.errorCount);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(WebRequestTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(WebRequestTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @ProbeListener(value="web:request::requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response) {
        this.logger.finest("[TM]requestStartEvent received - request = " + request + ": response = " + response);
        this.requestProcessTime.entry();
    }

    @ProbeListener(value="web:request::requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="statusCode") int statusCode) {
        this.requestProcessTime.exit();
        if (statusCode > 400) {
            this.errorCount.increment();
        }
        this.logger.finest("[TM]requestEndEvent received - request = " + request + ": response = " + response + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
        if (!this.webMonitoringEnabled) {
            this.tuneProbeListenerHandles(this.webMonitoringEnabled);
        }
    }

    public void enableProbeListenerHandles(boolean isEnabled) {
        if (isEnabled != this.webMonitoringEnabled) {
            this.webMonitoringEnabled = isEnabled;
            this.tuneProbeListenerHandles(this.webMonitoringEnabled);
        }
    }

    private void tuneProbeListenerHandles(boolean shouldEnable) {
        for (ProbeClientMethodHandle handle : this.handles) {
            if (shouldEnable) {
                handle.enable();
                continue;
            }
            handle.disable();
        }
    }

    public void enableMonitoring(boolean isEnable) {
    }

    public void enableMonitoringForSubElements(boolean isEnable) {
    }
}

