/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsScanner;
import com.sun.hk2.component.KeyValuePairParser;
import com.sun.hk2.component.LazyInhabitant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInhabitantsParser
extends InhabitantsParser {
    public static final String SERVICE_NAME = "ServiceName";
    private final Habitat habitat;
    private BundleContext osgiCtx;

    public OSGiInhabitantsParser(Habitat habitat, BundleContext ctx) {
        super(habitat);
        this.habitat = habitat;
        this.osgiCtx = ctx;
    }

    @Override
    public void parse(InhabitantsScanner scanner, Holder<ClassLoader> classLoader) throws IOException {
        for (KeyValuePairParser kvpp : scanner) {
            String className = null;
            ArrayList<String> contractNames = new ArrayList<String>();
            String serviceName = null;
            MultiMap<String, String> metadata = null;
            while (kvpp.hasNext()) {
                kvpp.parseNext();
                if (kvpp.getKey().equals("class")) {
                    className = kvpp.getValue();
                    continue;
                }
                if (kvpp.getKey().equals("index")) continue;
                if (metadata == null) {
                    metadata = new MultiMap<String, String>();
                }
                metadata.add(kvpp.getKey(), kvpp.getValue());
            }
            LazyInhabitant i = new LazyInhabitant(this.habitat, classLoader, className, metadata);
            this.habitat.add(i);
            for (String v : kvpp.findAll("index")) {
                if (metadata == null) {
                    metadata = new MultiMap();
                }
                metadata.add("index", v);
                int idx = v.indexOf(58);
                if (idx == -1) {
                    this.habitat.addIndex(i, v, null);
                    contractNames.add(v);
                    continue;
                }
                String contract = v.substring(0, idx);
                String name = v.substring(idx + 1);
                this.habitat.addIndex(i, contract, name);
                contractNames.add(name);
                metadata.add(contract, name);
                if (serviceName != null) assert (serviceName.equals(name));
                serviceName = name;
            }
            this.registerOSGiService(i, contractNames, serviceName, metadata);
        }
    }

    private void registerOSGiService(Inhabitant i, List<String> contractNames, String serviceName, MultiMap<String, String> metadata) {
        contractNames.add(i.typeName());
        Properties props = new Properties();
        if (serviceName != null) {
            props.setProperty(SERVICE_NAME, serviceName);
        }
        ServiceRegistration reg = this.osgiCtx.registerService(contractNames.toArray(new String[0]), (Object)new InhabitantServiceFactory(i), (Dictionary)props);
        Logger.logger.logp(Level.INFO, "InhabitantsParser", "registerOSGiService", "reg = {0}", reg);
    }

    static class InhabitantServiceFactory
    implements ServiceFactory {
        private Inhabitant i;

        public InhabitantServiceFactory(Inhabitant i) {
            this.i = i;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return this.i.get();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            this.i = null;
        }
    }
}

