/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.util.LogDomains;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.DeploymentUtils;

public final class QueryDescriptor
extends Descriptor {
    private String query;
    private String sql;
    private MethodDescriptor methodDescriptor;
    private transient Method method;
    private static final int NO_RETURN_TYPE_MAPPING = 0;
    private static final int RETURN_LOCAL_TYPES = 1;
    private static final int RETURN_REMOTE_TYPES = 2;
    private int returnTypeMapping;
    static Logger _logger = LogDomains.getLogger(DeploymentUtils.class, "javax.enterprise.system.tools.deployment");

    public QueryDescriptor() {
        this.query = null;
        this.sql = null;
        this.returnTypeMapping = 0;
    }

    public QueryDescriptor(QueryDescriptor otherQuery, Method m) {
        this.query = otherQuery.query;
        this.sql = otherQuery.sql;
        this.method = m;
        this.returnTypeMapping = otherQuery.returnTypeMapping;
    }

    public void setQueryMethod(Method m) {
        this.method = m;
    }

    public Method getQueryMethod() {
        return this.method;
    }

    public void setQueryMethodDescriptor(MethodDescriptor m) {
        this.methodDescriptor = m;
    }

    public MethodDescriptor getQueryMethodDescriptor() {
        return this.methodDescriptor;
    }

    public boolean getIsEjbQl() {
        return this.query != null;
    }

    public void setQuery(String query) {
        String newQuery;
        _logger.log(Level.FINE, "input query = '" + query + "'");
        String string = newQuery = query != null ? query.trim() : null;
        if (newQuery != null && newQuery.equals("")) {
            newQuery = null;
        }
        if (newQuery == null) {
            _logger.log(Level.FINE, "query has no content -- setting to NULL");
        } else {
            _logger.log(Level.FINE, "setting query to '" + newQuery + "'");
        }
        this.query = newQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean getHasSQL() {
        return this.sql != null;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public boolean getHasNoReturnTypeMapping() {
        return this.returnTypeMapping == 0;
    }

    public boolean getHasLocalReturnTypeMapping() {
        return this.returnTypeMapping == 1;
    }

    public boolean getHasRemoteReturnTypeMapping() {
        return this.returnTypeMapping == 2;
    }

    public void setHasNoReturnTypeMapping() {
        this.returnTypeMapping = 0;
    }

    public void setHasLocalReturnTypeMapping() {
        this.returnTypeMapping = 1;
    }

    public void setHasRemoteReturnTypeMapping() {
        this.returnTypeMapping = 2;
    }

    public int getReturnTypeMapping() {
        return this.returnTypeMapping;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Query ");
        if (this.getQueryMethodDescriptor() != null) {
            this.getQueryMethodDescriptor().print(toStringBuffer);
        }
        toStringBuffer.append("\n");
        if (this.getHasSQL()) {
            toStringBuffer.append("SQL : ").append(this.getSQL());
            return;
        }
        if (this.getIsEjbQl()) {
            toStringBuffer.append("EJB QL: ").append(this.query);
            return;
        }
        toStringBuffer.append(" No query associated");
    }
}

