/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractAttributeHandler;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DenyAllHandler
extends AbstractAttributeHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return DenyAll.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        Method annMethod = (Method)ainfo.getAnnotatedElement();
        if (ae.isAnnotationPresent(PermitAll.class) || ae.isAnnotationPresent(RolesAllowed.class)) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.inconsistentsecannotation", "This annotation is not consistent with other annotations.  One cannot have more than one of @RolesAllowed, @PermitAll, @DenyAll in the same AnnotatedElement."));
            return this.getDefaultFailedResult();
        }
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                Method m;
                MethodDescriptor md = (MethodDescriptor)next;
                if (this.hasMethodPermissionsFromDD(md, ejbDesc) || !TypeUtil.sameMethodSignature(m = md.getMethod(ejbDesc), annMethod)) continue;
                ejbDesc.addPermissionedMethod(MethodPermission.getExcludedMethodPermission(), md);
            }
        }
        return this.getDefaultProcessedResult();
    }
}

