/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;

public class ModuleContentValidator
extends DefaultDOLVisitor {
    private ReadableArchive archive_;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ModuleContentValidator.class);

    public ModuleContentValidator(ReadableArchive archive) {
        this.archive_ = archive;
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        if (serviceRef.hasWsdlFile()) {
            String wsdlFileUri = serviceRef.getWsdlFileUri();
            URL url = null;
            try {
                url = new URL(wsdlFileUri);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (url != null && (url.getProtocol().equals("http") || url.getProtocol().equals("https"))) {
                return;
            }
            File tmpFile = new File(wsdlFileUri);
            if (tmpFile.isAbsolute() && tmpFile.exists()) {
                return;
            }
            try {
                InputStream wsdlFileInputStream = this.archive_.getEntry(wsdlFileUri);
                if (wsdlFileInputStream == null) {
                    String msg = localStrings.getLocalString("enterprise.deployment.util.wsdlfilenotfound", "wsdl file {0} does not exist for service-ref {1}", new Object[]{wsdlFileUri, serviceRef.getName()});
                    DOLUtils.getDefaultLogger().severe(msg);
                    throw new RuntimeException(msg);
                }
                wsdlFileInputStream.close();
            }
            catch (IOException ioe) {
                String msg = localStrings.getLocalString("enterprise.deployment.util.wsdlfilenotreadable", "wsdl file {0}  for service-ref {1} cannot be opened : {2}", new Object[]{wsdlFileUri, serviceRef.getName(), ioe.getMessage()});
                DOLUtils.getDefaultLogger().severe(msg);
                throw new RuntimeException(ioe);
            }
        }
        if (serviceRef.hasMappingFile()) {
            String msg;
            String mappingFileUri = serviceRef.getMappingFileUri();
            try {
                InputStream mappingFileInputStream = this.archive_.getEntry(mappingFileUri);
                if (mappingFileInputStream == null) {
                    msg = localStrings.getLocalString("enterprise.deployment.util.mappingfilenotfound", "mapping file {0} does not exist for service-ref {1}", new Object[]{mappingFileUri, serviceRef.getName()});
                    DOLUtils.getDefaultLogger().severe(msg);
                    throw new RuntimeException(msg);
                }
                mappingFileInputStream.close();
            }
            catch (IOException ioe) {
                msg = localStrings.getLocalString("enterprise.deployment.util.mappingfilenotreadable", "mapping file {0}  for service-ref {1} cannot be opened : {2}", new Object[]{mappingFileUri, serviceRef.getName(), ioe.getMessage()});
                DOLUtils.getDefaultLogger().severe(msg);
                throw new RuntimeException(ioe);
            }
        }
    }

    public void accept(WebService webService) {
        block5: {
            try {
                if ("1.1".compareTo(webService.getWebServicesDescriptor().getSpecVersion()) < 0) {
                    Collection<WebServiceEndpoint> endpoints = webService.getEndpoints();
                    for (WebServiceEndpoint ep : endpoints) {
                        if (ep.implementedByWebComponent()) {
                            this.updateServletEndpointRuntime(ep);
                            continue;
                        }
                        String msg = localStrings.getLocalString("enterprise.deployment.unexpectedEJBEndpoint", "Unexpected EJB endpoint{0}", new Object[]{ep.getEndpointName()});
                        throw new DeploymentException(msg);
                    }
                    break block5;
                }
                String msg = localStrings.getLocalString("enterprise.deployment.unexpectedJAXRPCEndpoint", "Unexpected JAXRPC endpoint , this version is not supported", new Object[]{webService.getWebServicesDescriptor().getSpecVersion()});
                throw new DeploymentException(msg);
            }
            catch (Exception e) {
                RuntimeException ge = new RuntimeException(e.getMessage());
                ge.initCause(e);
                throw ge;
            }
        }
    }

    public void updateServletEndpointRuntime(WebServiceEndpoint endpoint) {
        endpoint.saveServletImplClass();
        WebComponentDescriptor webComp = endpoint.getWebComponentImpl();
        WebBundleDescriptor bundle = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComp);
        if (endpoints.size() > 1) {
            String msg = "Servlet " + endpoint.getWebComponentLink() + " implements " + endpoints.size() + " web service endpoints " + " but must only implement 1";
            throw new IllegalStateException(msg);
        }
        if (endpoint.getEndpointAddressUri() == null) {
            Set<String> urlPatterns = webComp.getUrlPatternsSet();
            if (urlPatterns.size() == 1) {
                String uri = urlPatterns.iterator().next();
                endpoint.setEndpointAddressUri(uri);
                Collection<SecurityConstraint> constraints = bundle.getSecurityConstraintsForUrlPattern(uri);
                for (SecurityConstraint next : constraints) {
                    UserDataConstraint dataConstraint = next.getUserDataConstraint();
                    String guarantee = dataConstraint != null ? dataConstraint.getTransportGuarantee() : null;
                    if (guarantee == null || !guarantee.equals("INTEGRAL") && !guarantee.equals("CONFIDENTIAL")) continue;
                    endpoint.setTransportGuarantee(guarantee);
                    break;
                }
            } else {
                String msg = localStrings.getLocalString("enterprise.deployment.unassignedaddress", "Endpoint {0} has not been assigned an endpoint address\\n and is associated with servlet {1} , which has  {2} urlPatterns", new Object[]{endpoint.getEndpointName(), webComp.getCanonicalName(), urlPatterns.size()});
                DOLUtils.getDefaultLogger().severe(msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle) {
        String wsdlDir = bundle.getWsdlDir();
        return uri != null && uri.startsWith(wsdlDir);
    }
}

