/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.template;

import com.sun.jsftemplating.layout.ProcessingCompleteException;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.template.BaseProcessingContext;
import com.sun.jsftemplating.layout.template.CustomParserCommand;
import com.sun.jsftemplating.layout.template.DefineParserCommand;
import com.sun.jsftemplating.layout.template.NameValuePair;
import com.sun.jsftemplating.layout.template.ProcessingContext;
import com.sun.jsftemplating.layout.template.ProcessingContextEnvironment;
import com.sun.jsftemplating.layout.template.TemplateParser;
import com.sun.jsftemplating.layout.template.TemplateReader;
import com.sun.jsftemplating.util.LayoutElementUtil;
import java.io.IOException;
import java.util.List;

public class CompositionParserCommand
implements CustomParserCommand {
    private boolean trimming = true;
    private String templateAttName = null;
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final ProcessingContext LAYOUT_COMPOSITION_CONTEXT = new LayoutCompositionContext();
    public static final CustomParserCommand DEFINE_PARSER_COMMAND = new DefineParserCommand();

    public CompositionParserCommand(boolean trim, String templateAttName) {
        this.trimming = trim;
        this.templateAttName = templateAttName;
    }

    public void process(ProcessingContext ctx, ProcessingContextEnvironment env, String name) throws IOException {
        TemplateReader reader = env.getReader();
        LayoutElement parent = env.getParent();
        if (this.trimming) {
            parent = parent.getLayoutDefinition();
            parent.getChildLayoutElements().clear();
        }
        List<NameValuePair> nvps = reader.readNameValuePairs(name, this.templateAttName, true);
        LayoutComposition compElt = new LayoutComposition(parent, LayoutElementUtil.getGeneratedId(name, reader.getNextIdNumber()), this.trimming);
        for (NameValuePair nvp : nvps) {
            if (nvp.getName().equals(this.templateAttName)) {
                compElt.setTemplate((String)nvp.getValue());
                continue;
            }
            if (nvp.getName().equals(REQUIRED_ATTRIBUTE)) {
                compElt.setRequired(Boolean.parseBoolean(nvp.getValue().toString()));
                continue;
            }
            compElt.setParameter(nvp.getName(), nvp.getValue());
        }
        parent.addChildLayoutElement(compElt);
        TemplateParser parser = reader.getTemplateParser();
        int ch = parser.nextChar();
        if (ch == 47) {
            reader.popTag();
        } else {
            parser.unread(ch);
            reader.process(LAYOUT_COMPOSITION_CONTEXT, compElt, LayoutElementUtil.isLayoutComponentChild(compElt));
        }
        if (this.trimming) {
            throw new ProcessingCompleteException((LayoutDefinition)parent);
        }
    }

    protected static class LayoutCompositionContext
    extends BaseProcessingContext {
        protected LayoutCompositionContext() {
        }

        public void beginSpecial(ProcessingContextEnvironment env, String content) throws IOException {
            if (content.equals("define")) {
                DEFINE_PARSER_COMMAND.process(this, env, content);
            } else {
                super.beginSpecial(env, content);
            }
        }
    }
}

