/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemInfo {
    private static final String APPNAME = "updatetool";
    private static final String INITFILE = "init.cfg";
    private static final String DEFAULTSFILE = "defaults.cfg";
    private static final String WIN_APP_DATA = "Application Data";
    private static final String MAC_APP_DATA = "/Library/Application Support/";
    private static final String eol = System.getProperty("line.separator");

    public static Proxy getProxy() {
        try {
            String line;
            File f = SystemInfo.getInitFile();
            if (!f.exists() && !(f = SystemInfo.getDefaultsFile()).exists()) {
                return null;
            }
            BufferedReader r = new BufferedReader(new FileReader(f));
            String phost = null;
            String pport = null;
            String pusername = null;
            String ppasswd = null;
            boolean preq = false;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("proxy.")) continue;
                String[] tokens = line.split("\\s*[:=]\\s*", 2);
                if (tokens[0].equals("proxy.host")) {
                    phost = tokens[1];
                    continue;
                }
                if (tokens[0].equals("proxy.port")) {
                    pport = tokens[1];
                    continue;
                }
                if (tokens[0].equals("proxy.required")) {
                    preq = Boolean.parseBoolean(tokens[1].trim());
                    continue;
                }
                if (tokens[0].equals("proxy.username")) {
                    pusername = tokens[1];
                    continue;
                }
                if (!tokens[0].equals("proxy.password")) continue;
                ppasswd = tokens[1];
            }
            if (preq) {
                InetSocketAddress addr = new InetSocketAddress(phost, Integer.parseInt(pport));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                return proxy;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SystemInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static void initUpdateToolProps(Properties props) throws Exception {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(SystemInfo.getInitFile()));
            out.write("[main]" + eol);
            out.write("date: " + new Date().getTime() + eol);
            out.write("optin.update.notification: " + props.getProperty("optin.update.notification") + eol);
            out.write("optin.usage.reporting: " + props.getProperty("optin.usage.reporting") + eol);
            String proxyStr = props.getProperty("proxy.URL").trim();
            if (proxyStr.length() > 0) {
                URL proxy = new URL(proxyStr);
                out.write("[network]" + eol);
                out.write("proxy.required: true" + eol);
                out.write("proxy.host: " + proxy.getHost() + eol);
                out.write("proxy.port: " + proxy.getPort() + eol);
            }
            out.close();
        }
        catch (IOException e) {
            throw new Exception("Unable to initialize properties", e);
        }
    }

    private static File getConfigDir() throws IOException {
        String homedir = System.getProperty("user.home");
        String osname = System.getProperty("os.name");
        String configpath = osname.startsWith("Windows") ? new String(homedir + File.separator + WIN_APP_DATA + File.separator + APPNAME) : (osname.startsWith("Mac OS") ? new String(homedir + MAC_APP_DATA + APPNAME) : new String(homedir + File.separator + "." + APPNAME));
        try {
            boolean success;
            File configdir = new File(configpath);
            if (!configdir.exists() && !(success = configdir.mkdirs())) {
                throw new IOException("Unable to access properties: mkdirs() failed: " + configpath);
            }
            if (!configdir.isDirectory()) {
                throw new IOException("Unable to access properties: file exists but is not a directory: " + configpath);
            }
            return configdir;
        }
        catch (SecurityException e) {
            throw new IOException("Unable to access updatetool preferences", e);
        }
    }

    private static File getInitFile() throws IOException {
        return new File(SystemInfo.getConfigDir(), INITFILE);
    }

    private static File getDefaultsFile() throws IOException {
        return new File(SystemInfo.getConfigDir(), DEFAULTSFILE);
    }
}

