/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.glassfish;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.glassfish.RegistrationUtil;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="PingService")
@Async
public class PingService
implements Startup,
PostConstruct {
    @Inject
    Logger logger;
    private static final long TIMER_INTERVAL = Long.getLong("com.sun.enterprise.registration.PING_TIMER_INTERVAL", 604800000L);

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        try {
            RegistrationUtil.synchUUID();
        }
        catch (RegistrationException ex) {
            this.logger.fine(ex.getMessage());
            return;
        }
        Timer pingTimer = new Timer("ping", true);
        TimerTask pingTask = new TimerTask(){

            public void run() {
                try {
                    Image img = RegistrationUtil.getUpdateCenterImage();
                    img.refreshCatalogs();
                    List list = img.getInventory(null, false);
                    ArrayList<String> pkgs = new ArrayList<String>();
                    for (Image.FmriState fs : list) {
                        pkgs.add(fs.fmri.getName());
                    }
                    Image.ImagePlan ip = img.makeInstallPlan(pkgs.toArray(new String[0]));
                    int numUpdates = ip.getProposedFmris().length;
                    PingService.this.logger.info("Number of available updates : " + numUpdates);
                    if (numUpdates > 0) {
                        PingService.this.logger.info("Available updates : ");
                        for (Fmri fmri : ip.getProposedFmris()) {
                            PingService.this.logger.info(fmri.toString());
                        }
                    }
                }
                catch (Exception e) {
                    PingService.this.logger.info(e.getMessage());
                }
            }
        };
        pingTimer.schedule(pingTask, 0L, TIMER_INTERVAL);
    }
}

